/*
 * Decompiled with CFR 0.152.
 */
package de.tudarmstadt.ukp.wikipedia.api.util;

import de.tudarmstadt.ukp.wikipedia.api.util.SerializableDirectedGraph;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import org.jgrapht.DirectedGraph;
import org.jgrapht.graph.DefaultEdge;

public final class GraphSerialization {
    private GraphSerialization() {
    }

    public static void saveGraph(DirectedGraph<Integer, DefaultEdge> graph, String location) throws IOException {
        File file = new File(location);
        file.createNewFile();
        if (!file.canWrite()) {
            throw new IOException("Cannot write to file " + location);
        }
        GraphSerialization.saveGraph(graph, file);
    }

    public static void saveGraph(DirectedGraph<Integer, DefaultEdge> graph, File file) throws IOException {
        SerializableDirectedGraph serialGraph = new SerializableDirectedGraph(graph);
        FileOutputStream fos = null;
        ObjectOutputStream out = null;
        fos = new FileOutputStream(file);
        out = new ObjectOutputStream(fos);
        out.writeObject(serialGraph);
        out.close();
    }

    public static DirectedGraph<Integer, DefaultEdge> loadGraph(String location) throws IOException, ClassNotFoundException {
        File file = new File(location);
        if (!file.canWrite()) {
            throw new IOException("Cannot read from file " + location);
        }
        return GraphSerialization.loadGraph(file);
    }

    public static DirectedGraph<Integer, DefaultEdge> loadGraph(File file) throws IOException, ClassNotFoundException {
        SerializableDirectedGraph serialGraph = null;
        FileInputStream fin = null;
        ObjectInputStream in = null;
        fin = new FileInputStream(file);
        in = new ObjectInputStream(fin);
        serialGraph = (SerializableDirectedGraph)in.readObject();
        in.close();
        return serialGraph.getGraph();
    }
}

