/*
 * Decompiled with CFR 0.152.
 */
package de.tudarmstadt.ukp.wikipedia.api.tutorial;

import de.tudarmstadt.ukp.wikipedia.api.Category;
import de.tudarmstadt.ukp.wikipedia.api.DatabaseConfiguration;
import de.tudarmstadt.ukp.wikipedia.api.Page;
import de.tudarmstadt.ukp.wikipedia.api.WikiConstants;
import de.tudarmstadt.ukp.wikipedia.api.Wikipedia;
import de.tudarmstadt.ukp.wikipedia.api.exception.WikiApiException;
import de.tudarmstadt.ukp.wikipedia.api.exception.WikiPageNotFoundException;
import java.util.Iterator;

public class T4_Categories
implements WikiConstants {
    public static void main(String[] args) throws WikiApiException {
        Category cat;
        DatabaseConfiguration dbConfig = new DatabaseConfiguration();
        dbConfig.setHost("SERVER_URL");
        dbConfig.setDatabase("DATABASE");
        dbConfig.setUser("USER");
        dbConfig.setPassword("PASSWORD");
        dbConfig.setLanguage(WikiConstants.Language.german);
        Wikipedia wiki = new Wikipedia(dbConfig);
        String title = "S\u00e4ugetiere";
        try {
            cat = wiki.getCategory(title);
        }
        catch (WikiPageNotFoundException e) {
            throw new WikiApiException("Category " + title + " does not exist");
        }
        StringBuilder sb = new StringBuilder();
        sb.append("Title : " + cat.getTitle() + LF);
        sb.append(LF);
        sb.append("# super categories : " + cat.getParents().size() + LF);
        for (Category parent : cat.getParents()) {
            sb.append("  " + parent.getTitle() + LF);
        }
        sb.append(LF);
        sb.append("# sub categories : " + cat.getChildren().size() + LF);
        for (Category child : cat.getChildren()) {
            sb.append("  " + child.getTitle() + LF);
        }
        sb.append(LF);
        sb.append("# pages : " + cat.getArticles().size() + LF);
        for (Page page : cat.getArticles()) {
            sb.append("  " + page.getTitle() + LF);
        }
        sb.append("# pageIDs : " + cat.getArticleIds().size() + LF);
        Iterator<Object> i$ = cat.getArticleIds().iterator();
        while (i$.hasNext()) {
            int pageID = (Integer)i$.next();
            sb.append("  " + pageID + LF);
        }
        System.out.println(sb);
    }
}

