/*
 * Decompiled with CFR 0.152.
 */
package de.tudarmstadt.ukp.wikipedia.api.tutorial;

import de.tudarmstadt.ukp.wikipedia.api.Category;
import de.tudarmstadt.ukp.wikipedia.api.DatabaseConfiguration;
import de.tudarmstadt.ukp.wikipedia.api.Page;
import de.tudarmstadt.ukp.wikipedia.api.Title;
import de.tudarmstadt.ukp.wikipedia.api.WikiConstants;
import de.tudarmstadt.ukp.wikipedia.api.Wikipedia;
import de.tudarmstadt.ukp.wikipedia.api.exception.WikiApiException;
import de.tudarmstadt.ukp.wikipedia.api.exception.WikiPageNotFoundException;

public class T3_PageDetails
implements WikiConstants {
    public static void main(String[] args) throws WikiApiException {
        Page page;
        DatabaseConfiguration dbConfig = new DatabaseConfiguration();
        dbConfig.setHost("SERVER_URL");
        dbConfig.setDatabase("DATABASE");
        dbConfig.setUser("USER");
        dbConfig.setPassword("PASSWORD");
        dbConfig.setLanguage(WikiConstants.Language.german);
        Wikipedia wiki = new Wikipedia(dbConfig);
        String title = "Hello world";
        try {
            page = wiki.getPage(title);
        }
        catch (WikiPageNotFoundException e) {
            throw new WikiApiException("Page " + title + " does not exist");
        }
        StringBuilder sb = new StringBuilder();
        sb.append("Queried string : " + title + LF);
        sb.append("Title          : " + page.getTitle() + LF);
        sb.append(LF);
        sb.append("Redirects" + LF);
        for (String redirect : page.getRedirects()) {
            sb.append("  " + new Title(redirect).getPlainTitle() + LF);
        }
        sb.append(LF);
        sb.append("Categories" + LF);
        for (Category category : page.getCategories()) {
            sb.append("  " + category.getTitle() + LF);
        }
        sb.append(LF);
        sb.append("In-Links" + LF);
        for (Page inLinkPage : page.getInlinks()) {
            sb.append("  " + inLinkPage.getTitle() + LF);
        }
        sb.append(LF);
        sb.append("Out-Links" + LF);
        for (Page outLinkPage : page.getOutlinks()) {
            sb.append("  " + outLinkPage.getTitle() + LF);
        }
        System.out.println(sb);
    }
}

