/*
 * Decompiled with CFR 0.152.
 */
package de.tudarmstadt.ukp.wikipedia.api.sweble;

import de.fau.cs.osr.ptk.common.Visitor;
import de.fau.cs.osr.ptk.common.ast.AstNode;
import de.fau.cs.osr.ptk.common.ast.NodeList;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import javax.xml.bind.JAXBException;
import org.sweble.wikitext.engine.Page;
import org.sweble.wikitext.engine.PageTitle;
import org.sweble.wikitext.engine.config.WikiConfigurationInterface;
import org.sweble.wikitext.engine.utils.SimpleWikiConfiguration;
import org.sweble.wikitext.lazy.LinkTargetException;
import org.sweble.wikitext.lazy.parser.ExternalLink;
import org.sweble.wikitext.lazy.parser.ImageLink;
import org.sweble.wikitext.lazy.parser.InternalLink;
import org.sweble.wikitext.lazy.parser.Paragraph;
import org.sweble.wikitext.lazy.parser.Section;

public class InternalLinkAnchorExtractor
extends Visitor {
    private final SimpleWikiConfiguration config;
    private List<String> anchors;

    public InternalLinkAnchorExtractor() {
        SimpleWikiConfiguration config = null;
        try {
            config = new SimpleWikiConfiguration("classpath:/org/sweble/wikitext/engine/SimpleWikiConfiguration.xml");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (JAXBException e) {
            e.printStackTrace();
        }
        this.config = config;
    }

    public InternalLinkAnchorExtractor(SimpleWikiConfiguration config) {
        this.config = config;
    }

    protected boolean before(AstNode node) {
        this.anchors = new LinkedList<String>();
        return super.before((Object)node);
    }

    protected Object after(AstNode node, Object result) {
        return this.anchors;
    }

    public void visit(AstNode n) {
        this.iterate(n);
    }

    public void visit(NodeList n) {
        this.iterate((AstNode)n);
    }

    public void visit(Page p) {
        this.iterate((AstNode)p.getContent());
    }

    public void visit(ExternalLink link) {
    }

    public void visit(ImageLink n) {
    }

    public void visit(InternalLink link) {
        try {
            PageTitle page = PageTitle.make((WikiConfigurationInterface)this.config, (String)link.getTarget());
            if (page.getNamespace().equals((Object)this.config.getNamespace("Category"))) {
                return;
            }
        }
        catch (LinkTargetException e) {
            // empty catch block
        }
        if (link.getTitle().getContent() == null || link.getTitle().getContent().isEmpty()) {
            String anchor = link.getTarget();
            if (!anchor.contains(":")) {
                this.add(link.getTarget());
            }
        } else {
            this.iterate((AstNode)link.getTitle());
        }
    }

    public void visit(Section s) {
        this.iterate((AstNode)s.getBody());
    }

    public void visit(Paragraph p) {
        this.iterate((AstNode)p.getContent());
    }

    private void add(String s) {
        if (s.isEmpty()) {
            return;
        }
        this.anchors.add(s);
    }
}

