/*
 * Decompiled with CFR 0.152.
 */
package de.tudarmstadt.ukp.wikipedia.api.hibernate;

import de.tudarmstadt.ukp.wikipedia.api.WikiConstants;
import de.tudarmstadt.ukp.wikipedia.api.Wikipedia;
import de.tudarmstadt.ukp.wikipedia.api.hibernate.MetaData;
import de.tudarmstadt.ukp.wikipedia.api.hibernate.WikiHibernateUtil;
import java.io.Serializable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.LockOptions;
import org.hibernate.SessionFactory;

public class MetaDataDAO
implements WikiConstants {
    private final Log logger = LogFactory.getLog(this.getClass());
    private static final String META_DATA_CLASS = "de.tudarmstadt.ukp.wikipedia.api.hibernate.Category";
    private final SessionFactory sessionFactory;
    private Wikipedia wiki;

    public MetaDataDAO(Wikipedia wiki) {
        this.wiki = wiki;
        this.sessionFactory = this.getSessionFactory();
    }

    protected SessionFactory getSessionFactory() {
        try {
            this.logger.info((Object)("Using language: " + (Object)((Object)this.wiki.getLanguage())));
            return WikiHibernateUtil.getSessionFactory(this.wiki.getDatabaseConfiguration());
        }
        catch (Exception e) {
            this.logger.error((Object)"Could not locate SessionFactory in JNDI", (Throwable)e);
            throw new IllegalStateException("Could not locate SessionFactory in JNDI", e);
        }
    }

    public void persist(MetaData transientInstance) {
        this.logger.debug((Object)"persisting MetaData instance");
        try {
            this.sessionFactory.getCurrentSession().persist((Object)transientInstance);
            this.logger.debug((Object)"persist successful");
        }
        catch (RuntimeException re) {
            this.logger.error((Object)"persist failed", (Throwable)re);
            throw re;
        }
    }

    public void attachDirty(MetaData instance) {
        this.logger.debug((Object)"attaching dirty MetaData instance");
        try {
            this.sessionFactory.getCurrentSession().saveOrUpdate((Object)instance);
            this.logger.debug((Object)"attach successful");
        }
        catch (RuntimeException re) {
            this.logger.error((Object)"attach failed", (Throwable)re);
            throw re;
        }
    }

    public void attachClean(MetaData instance) {
        this.logger.debug((Object)"attaching clean MetaData instance");
        try {
            this.sessionFactory.getCurrentSession().buildLockRequest(LockOptions.NONE).lock((Object)instance);
            this.logger.debug((Object)"attach successful");
        }
        catch (RuntimeException re) {
            this.logger.error((Object)"attach failed", (Throwable)re);
            throw re;
        }
    }

    public void delete(MetaData persistentInstance) {
        this.logger.debug((Object)"deleting MetaData instance");
        try {
            this.sessionFactory.getCurrentSession().delete((Object)persistentInstance);
            this.logger.debug((Object)"delete successful");
        }
        catch (RuntimeException re) {
            this.logger.error((Object)"delete failed", (Throwable)re);
            throw re;
        }
    }

    public MetaData merge(MetaData detachedInstance) {
        this.logger.debug((Object)"merging MetaData instance");
        try {
            MetaData result = (MetaData)this.sessionFactory.getCurrentSession().merge((Object)detachedInstance);
            this.logger.debug((Object)"merge successful");
            return result;
        }
        catch (RuntimeException re) {
            this.logger.error((Object)"merge failed", (Throwable)re);
            throw re;
        }
    }

    public MetaData findById(Long id) {
        this.logger.debug((Object)("getting MetaData instance with id: " + id));
        try {
            MetaData instance = (MetaData)this.sessionFactory.getCurrentSession().get(META_DATA_CLASS, (Serializable)id);
            if (instance == null) {
                this.logger.debug((Object)"get successful, no instance found");
            } else {
                this.logger.debug((Object)"get successful, instance found");
            }
            return instance;
        }
        catch (RuntimeException re) {
            this.logger.error((Object)"get failed", (Throwable)re);
            throw re;
        }
    }
}

