/*
 * Decompiled with CFR 0.152.
 */
package de.tudarmstadt.ukp.wikipedia.api;

import de.tudarmstadt.ukp.wikipedia.api.Title;
import de.tudarmstadt.ukp.wikipedia.api.Wikipedia;
import de.tudarmstadt.ukp.wikipedia.api.exception.WikiTitleParsingException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.hibernate.Session;

public class TitleIterator
implements Iterator<Title> {
    private TitleBuffer buffer;

    public TitleIterator(Wikipedia wiki, int bufferSize) {
        this.buffer = new TitleBuffer(bufferSize, wiki);
    }

    @Override
    public boolean hasNext() {
        return this.buffer.hasNext();
    }

    @Override
    public Title next() {
        return this.buffer.next();
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    class TitleBuffer {
        private Wikipedia wiki;
        private List<String> titleStringBuffer;
        private int maxBufferSize;
        private int bufferFillSize;
        private int bufferOffset;
        private int dataOffset;

        public TitleBuffer(int bufferSize, Wikipedia wiki) {
            this.maxBufferSize = bufferSize;
            this.wiki = wiki;
            this.titleStringBuffer = new ArrayList<String>();
            this.bufferFillSize = 0;
            this.bufferOffset = 0;
            this.dataOffset = 0;
        }

        public boolean hasNext() {
            if (this.bufferOffset < this.bufferFillSize) {
                return true;
            }
            return this.fillBuffer();
        }

        public Title next() {
            if (this.bufferOffset < this.bufferFillSize) {
                return this.getBufferElement();
            }
            if (this.fillBuffer()) {
                return this.getBufferElement();
            }
            return null;
        }

        private Title getBufferElement() {
            String titleString = this.titleStringBuffer.get(this.bufferOffset);
            Title title = null;
            try {
                title = new Title(titleString);
            }
            catch (WikiTitleParsingException e) {
                e.printStackTrace();
            }
            ++this.bufferOffset;
            ++this.dataOffset;
            return title;
        }

        private boolean fillBuffer() {
            Session session = this.wiki.__getHibernateSession();
            session.beginTransaction();
            List returnList = session.createSQLQuery("select p.name from PageMapLine as p").setFirstResult(this.dataOffset).setMaxResults(this.maxBufferSize).setFetchSize(this.maxBufferSize).list();
            session.getTransaction().commit();
            this.titleStringBuffer.clear();
            this.bufferOffset = 0;
            this.bufferFillSize = 0;
            this.titleStringBuffer.addAll(returnList);
            if (this.titleStringBuffer.size() > 0) {
                this.bufferFillSize = this.titleStringBuffer.size();
                return true;
            }
            return false;
        }
    }
}

