/*
 * Decompiled with CFR 0.152.
 */
package de.tudarmstadt.ukp.wikipedia.api;

import de.tudarmstadt.ukp.wikipedia.api.exception.WikiTitleParsingException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Title {
    private String wikiStyleTitle;
    private String plainTitle;
    private String entity;
    private String disambiguationText;
    private String rawTitleText;
    private final String sectionText;

    public Title(String titleText) throws WikiTitleParsingException {
        if (titleText.length() == 0) {
            throw new WikiTitleParsingException("Title is empty.");
        }
        this.rawTitleText = titleText;
        String titlePart = null;
        String sectionPart = null;
        if (this.rawTitleText.contains("#")) {
            titlePart = this.rawTitleText.substring(0, this.rawTitleText.lastIndexOf("#"));
            sectionPart = this.rawTitleText.substring(this.rawTitleText.lastIndexOf("#") + 1, this.rawTitleText.length());
        } else {
            titlePart = this.rawTitleText;
        }
        this.sectionText = sectionPart;
        String regexFindParts = "(.*?)[ _]\\((.+?)\\)$";
        Pattern patternNamespace = Pattern.compile(regexFindParts);
        Matcher matcherNamespace = patternNamespace.matcher(this.decodeTitleWikistyle(titlePart));
        if (matcherNamespace.find()) {
            this.entity = matcherNamespace.group(1);
            this.disambiguationText = matcherNamespace.group(2);
            String relevantTitleParts = this.entity + " (" + this.disambiguationText + ")";
            this.plainTitle = this.decodeTitleWikistyle(relevantTitleParts);
            this.wikiStyleTitle = this.encodeTitleWikistyle(relevantTitleParts);
        } else {
            this.plainTitle = this.decodeTitleWikistyle(titlePart);
            this.wikiStyleTitle = this.encodeTitleWikistyle(titlePart);
            this.entity = this.plainTitle;
            this.disambiguationText = null;
        }
        if (this.getEntity() == null) {
            throw new WikiTitleParsingException("Title was not properly initialized.");
        }
    }

    private String encodeTitleWikistyle(String pTitle) {
        String encodedTitle = pTitle.replace(' ', '_');
        return encodedTitle;
    }

    private String decodeTitleWikistyle(String pTitle) {
        String encodedTitle = pTitle.replace('_', ' ');
        return encodedTitle;
    }

    public String getDisambiguationText() {
        return this.disambiguationText;
    }

    public String getEntity() {
        return this.entity;
    }

    public String getPlainTitle() {
        return this.plainTitle;
    }

    public String getSectionText() {
        return this.sectionText;
    }

    public String getWikiStyleTitle() {
        return this.wikiStyleTitle;
    }

    protected String getRawTitleText() {
        return this.rawTitleText;
    }

    public String toString() {
        return this.getPlainTitle();
    }
}

