/*
 * Decompiled with CFR 0.152.
 */
package de.tudarmstadt.ukp.wikipedia.api;

import de.tudarmstadt.ukp.wikipedia.api.Page;
import de.tudarmstadt.ukp.wikipedia.api.Wikipedia;
import de.tudarmstadt.ukp.wikipedia.api.exception.WikiApiException;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class PageQueryIterator
implements Iterator<Page> {
    private final Log logger = LogFactory.getLog(this.getClass());
    private Wikipedia wiki;
    private int iterPosition;
    private List<Integer> pageIDs;

    public PageQueryIterator(Wikipedia wiki, List<Integer> pPageIDs) {
        this.wiki = wiki;
        this.iterPosition = 0;
        this.pageIDs = pPageIDs;
    }

    @Override
    public boolean hasNext() {
        return this.iterPosition < this.pageIDs.size();
    }

    @Override
    public Page next() {
        Page page = null;
        try {
            page = this.wiki.getPage(this.pageIDs.get(this.iterPosition));
        }
        catch (WikiApiException e) {
            this.logger.error((Object)("Could not load page with id " + this.pageIDs.get(this.iterPosition)));
            e.printStackTrace();
        }
        ++this.iterPosition;
        return page;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }
}

