/*
 * Decompiled with CFR 0.152.
 */
package de.tudarmstadt.ukp.wikipedia.api;

import de.tudarmstadt.ukp.wikipedia.api.Page;
import de.tudarmstadt.ukp.wikipedia.api.PageQuery;
import de.tudarmstadt.ukp.wikipedia.api.PageQueryIterator;
import de.tudarmstadt.ukp.wikipedia.api.Wikipedia;
import de.tudarmstadt.ukp.wikipedia.api.exception.WikiApiException;
import de.tudarmstadt.ukp.wikipedia.api.exception.WikiPageNotFoundException;
import de.tudarmstadt.ukp.wikipedia.util.ApiUtilities;
import de.tudarmstadt.ukp.wikipedia.util.StringUtils;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.Session;

public class PageQueryIterable
implements Iterable<Page> {
    private final Log logger = LogFactory.getLog(this.getClass());
    private Wikipedia wiki;
    private List<Integer> pageIdList;

    public PageQueryIterable(Wikipedia wiki, PageQuery query) throws WikiApiException {
        String conditionString;
        this.wiki = wiki;
        this.pageIdList = new ArrayList<Integer>();
        String hql = "select p.pageId from Page as p ";
        ArrayList<String> conditions = new ArrayList<String>();
        if (query.onlyDisambiguationPages()) {
            conditions.add("p.isDisambiguation = 1");
        }
        if (query.onlyArticlePages()) {
            conditions.add("p.isDisambiguation = 0");
        }
        if (query.getTitlePattern() != "") {
            conditions.add("p.name like '" + query.getTitlePattern() + "'");
        }
        if ((conditionString = StringUtils.join(conditions, " AND ")).length() > 0) {
            hql = hql + "where " + conditionString;
        }
        Session session = this.wiki.__getHibernateSession();
        session.beginTransaction();
        List idList = session.createQuery(hql).list();
        session.getTransaction().commit();
        int progress = 0;
        for (Integer pageID : idList) {
            int categoriesSize;
            int outlinkSize;
            int inlinkSize;
            ApiUtilities.printProgressInfo(++progress, idList.size(), 100, ApiUtilities.ProgressInfoMode.TEXT, "searching " + idList.size() + " pages ... ");
            if (query.getMaxCategories() == Integer.MAX_VALUE && query.getMaxIndegree() == Integer.MAX_VALUE && query.getMaxOutdegree() == Integer.MAX_VALUE && query.getMaxRedirects() == Integer.MAX_VALUE && query.getMaxTokens() == Integer.MAX_VALUE && query.getMinCategories() == 0 && query.getMinIndegree() == 0 && query.getMinOutdegree() == 0 && query.getMinRedirects() == 0 && query.getMinTokens() == 0) {
                this.pageIdList.add(pageID);
                continue;
            }
            Page page = null;
            try {
                page = wiki.getPage(pageID);
            }
            catch (WikiPageNotFoundException e) {
                this.logger.error((Object)("Page with pageID " + pageID + " could not be found. Fatal error. Terminating."));
                e.printStackTrace();
                System.exit(1);
            }
            String[] tokens = page.getPlainText().split(" ");
            if (query.getMinIndegree() < 0 || query.getMaxIndegree() < 0 || query.getMinIndegree() > query.getMaxIndegree()) {
                query.setMinIndegree(0);
                query.setMaxIndegree(Integer.MAX_VALUE);
            }
            if (query.getMinOutdegree() < 0 || query.getMaxOutdegree() < 0 || query.getMinOutdegree() > query.getMaxOutdegree()) {
                query.setMinOutdegree(0);
                query.setMaxOutdegree(Integer.MAX_VALUE);
            }
            if (query.getMinRedirects() < 0 || query.getMaxRedirects() < 0 || query.getMinRedirects() > query.getMaxRedirects()) {
                query.setMinRedirects(0);
                query.setMaxRedirects(Integer.MAX_VALUE);
            }
            if (query.getMinCategories() < 0 || query.getMaxCategories() < 0 || query.getMinCategories() > query.getMaxCategories()) {
                query.setMinCategories(0);
                query.setMaxCategories(Integer.MAX_VALUE);
            }
            if (query.getMinCategories() < 0 || query.getMaxCategories() < 0 || query.getMinCategories() > query.getMaxCategories()) {
                query.setMinCategories(0);
                query.setMaxCategories(Integer.MAX_VALUE);
            }
            if (query.getMinTokens() < 0 || query.getMaxTokens() < 0 || query.getMinTokens() > query.getMaxTokens()) {
                query.setMinTokens(0);
                query.setMaxTokens(Integer.MAX_VALUE);
            }
            if ((inlinkSize = page.getNumberOfInlinks()) < query.getMinIndegree() || inlinkSize > query.getMaxIndegree() || (outlinkSize = page.getNumberOfOutlinks()) < query.getMinOutdegree() || outlinkSize > query.getMaxOutdegree() || page.getRedirects().size() < query.getMinRedirects() || page.getRedirects().size() > query.getMaxRedirects() || (categoriesSize = page.getCategories().size()) < query.getMinCategories() || categoriesSize > query.getMaxCategories() || tokens.length < query.getMinTokens() || tokens.length > query.getMaxTokens()) continue;
            this.pageIdList.add(pageID);
        }
        this.logger.info((Object)("Query selected " + this.pageIdList.size() + " pages."));
    }

    @Override
    public Iterator<Page> iterator() {
        return new PageQueryIterator(this.wiki, this.pageIdList);
    }
}

