/*
 * Decompiled with CFR 0.152.
 */
package de.tudarmstadt.ukp.wikipedia.api;

import de.tudarmstadt.ukp.wikipedia.api.Page;
import de.tudarmstadt.ukp.wikipedia.api.Wikipedia;
import de.tudarmstadt.ukp.wikipedia.api.exception.WikiApiException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.Session;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;

public class PageIterator
implements Iterator<Page> {
    private final Log logger = LogFactory.getLog(this.getClass());
    private final PageBuffer buffer;

    public PageIterator(Wikipedia wiki, Set<String> ids, Set<String> titles, int bufferSize) {
        this.buffer = new PageBuffer(bufferSize, wiki, ids, titles);
    }

    public PageIterator(Wikipedia wiki, boolean onlyArticles, int bufferSize) {
        this.buffer = new PageBuffer(bufferSize, wiki, onlyArticles);
    }

    @Override
    public boolean hasNext() {
        return this.buffer.hasNext();
    }

    @Override
    public Page next() {
        return this.buffer.next();
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    class PageBuffer {
        private final Wikipedia wiki;
        private final boolean onlyArticles;
        private final List<Page> buffer;
        private final int maxBufferSize;
        private int bufferFillSize;
        private int bufferOffset;
        private long lastPage;
        private List<String> pageIds = new LinkedList<String>();
        private List<String> pageTitles = new LinkedList<String>();
        boolean loadFromList;

        public PageBuffer(int bufferSize, Wikipedia wiki, boolean onlyArticles) {
            this.maxBufferSize = bufferSize;
            this.wiki = wiki;
            this.onlyArticles = onlyArticles;
            this.buffer = new ArrayList<Page>();
            this.bufferFillSize = 0;
            this.bufferOffset = 0;
            this.lastPage = 0L;
            this.loadFromList = false;
        }

        public PageBuffer(int bufferSize, Wikipedia wiki, Set<String> ids, Set<String> titles) {
            this.maxBufferSize = bufferSize;
            this.wiki = wiki;
            this.buffer = new ArrayList<Page>();
            this.onlyArticles = false;
            this.bufferFillSize = 0;
            this.bufferOffset = 0;
            this.lastPage = 0L;
            this.pageIds = new LinkedList<String>(ids);
            this.pageTitles = new LinkedList<String>(titles);
            this.loadFromList = true;
        }

        public boolean hasNext() {
            if (this.bufferOffset < this.bufferFillSize) {
                return true;
            }
            return this.fillBuffer();
        }

        public Page next() {
            if (this.bufferOffset < this.bufferFillSize) {
                return this.getBufferElement();
            }
            if (this.fillBuffer()) {
                return this.getBufferElement();
            }
            return null;
        }

        private Page getBufferElement() {
            Page page = this.buffer.get(this.bufferOffset);
            ++this.bufferOffset;
            return page;
        }

        private boolean fillBuffer() {
            if (this.loadFromList) {
                this.buffer.clear();
                this.bufferOffset = 0;
                this.bufferFillSize = 0;
                if (this.pageIds.isEmpty() && this.pageTitles.isEmpty()) {
                    return false;
                }
                while (this.bufferFillSize <= this.maxBufferSize && !this.pageIds.isEmpty()) {
                    String id = this.pageIds.remove(0);
                    if (id == null || id.isEmpty()) continue;
                    try {
                        this.buffer.add(this.wiki.getPage(Integer.parseInt(id)));
                        ++this.bufferFillSize;
                    }
                    catch (WikiApiException e) {
                        PageIterator.this.logger.warn((Object)("Missing article with id " + id));
                    }
                }
                while (this.bufferFillSize <= this.maxBufferSize && !this.pageTitles.isEmpty()) {
                    String title = this.pageTitles.remove(0);
                    if (title == null || title.isEmpty()) continue;
                    try {
                        this.buffer.add(this.wiki.getPage(title));
                        ++this.bufferFillSize;
                    }
                    catch (WikiApiException e) {
                        PageIterator.this.logger.warn((Object)("Missing article with title \"" + title + "\""));
                    }
                }
                if (this.buffer.size() > 0) {
                    this.bufferFillSize = this.buffer.size();
                    return true;
                }
                return false;
            }
            Session session = this.wiki.__getHibernateSession();
            session.beginTransaction();
            List returnValues = null;
            returnValues = this.onlyArticles ? session.createCriteria(de.tudarmstadt.ukp.wikipedia.api.hibernate.Page.class).add((Criterion)Restrictions.eq((String)"isDisambiguation", (Object)false)).add((Criterion)Restrictions.gt((String)"id", (Object)this.lastPage)).setMaxResults(this.maxBufferSize).list() : session.createCriteria(de.tudarmstadt.ukp.wikipedia.api.hibernate.Page.class).add((Criterion)Restrictions.gt((String)"id", (Object)this.lastPage)).setMaxResults(this.maxBufferSize).list();
            session.getTransaction().commit();
            this.buffer.clear();
            this.bufferOffset = 0;
            this.bufferFillSize = 0;
            for (Object o : returnValues) {
                if (o == null) {
                    return false;
                }
                de.tudarmstadt.ukp.wikipedia.api.hibernate.Page hibernatePage = (de.tudarmstadt.ukp.wikipedia.api.hibernate.Page)o;
                long id = hibernatePage.getId();
                try {
                    Page apiPage = new Page(this.wiki, id, hibernatePage);
                    if (this.onlyArticles) {
                        if (!apiPage.isRedirect()) {
                            this.buffer.add(apiPage);
                        }
                    } else {
                        this.buffer.add(apiPage);
                    }
                }
                catch (WikiApiException e) {
                    PageIterator.this.logger.error((Object)("Page with hibernateID " + id + " not found."));
                    e.printStackTrace();
                }
                this.lastPage = id;
            }
            if (this.buffer.size() > 0) {
                this.bufferFillSize = this.buffer.size();
                return true;
            }
            return false;
        }
    }
}

