/*
 * Decompiled with CFR 0.152.
 */
package de.tudarmstadt.ukp.wikipedia.api;

import de.tudarmstadt.ukp.wikipedia.api.Category;
import de.tudarmstadt.ukp.wikipedia.api.Wikipedia;
import de.tudarmstadt.ukp.wikipedia.api.exception.WikiApiException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.Session;

public class CategoryIterator
implements Iterator<Category> {
    private final Log logger = LogFactory.getLog(this.getClass());
    private CategoryBuffer buffer;

    public CategoryIterator(Wikipedia wiki, int bufferSize) {
        this.buffer = new CategoryBuffer(bufferSize, wiki);
    }

    @Override
    public boolean hasNext() {
        return this.buffer.hasNext();
    }

    @Override
    public Category next() {
        return this.buffer.next();
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    class CategoryBuffer {
        private Wikipedia wiki;
        private List<Category> buffer;
        private int maxBufferSize;
        private int bufferFillSize;
        private int bufferOffset;
        private int dataOffset;

        public CategoryBuffer(int bufferSize, Wikipedia wiki) {
            this.maxBufferSize = bufferSize;
            this.wiki = wiki;
            this.buffer = new ArrayList<Category>();
            this.bufferFillSize = 0;
            this.bufferOffset = 0;
            this.dataOffset = 0;
        }

        public boolean hasNext() {
            if (this.bufferOffset < this.bufferFillSize) {
                return true;
            }
            return this.fillBuffer();
        }

        public Category next() {
            if (this.bufferOffset < this.bufferFillSize) {
                return this.getBufferElement();
            }
            if (this.fillBuffer()) {
                return this.getBufferElement();
            }
            return null;
        }

        private Category getBufferElement() {
            Category cat = this.buffer.get(this.bufferOffset);
            ++this.bufferOffset;
            ++this.dataOffset;
            return cat;
        }

        private boolean fillBuffer() {
            Session session = this.wiki.__getHibernateSession();
            session.beginTransaction();
            List returnValues = null;
            returnValues = session.createCriteria(de.tudarmstadt.ukp.wikipedia.api.hibernate.Category.class).setFirstResult(this.dataOffset).setMaxResults(this.maxBufferSize).setFetchSize(this.maxBufferSize).list();
            session.getTransaction().commit();
            this.buffer.clear();
            this.bufferOffset = 0;
            this.bufferFillSize = 0;
            for (Object o : returnValues) {
                if (o == null) {
                    return false;
                }
                de.tudarmstadt.ukp.wikipedia.api.hibernate.Category hibernateCategory = (de.tudarmstadt.ukp.wikipedia.api.hibernate.Category)o;
                long id = hibernateCategory.getId();
                try {
                    Category apiCategory = new Category(this.wiki, id);
                    this.buffer.add(apiCategory);
                }
                catch (WikiApiException e) {
                    CategoryIterator.this.logger.error((Object)("Page with hibernateID " + id + " not found."));
                    e.printStackTrace();
                }
            }
            if (this.buffer.size() > 0) {
                this.bufferFillSize = this.buffer.size();
                return true;
            }
            return false;
        }
    }
}

