/*
 * Decompiled with CFR 0.152.
 */
package de.tudarmstadt.ukp.wikipedia.api;

import de.tudarmstadt.ukp.wikipedia.api.Category;
import de.tudarmstadt.ukp.wikipedia.api.CategoryGraphManager;
import de.tudarmstadt.ukp.wikipedia.api.CycleHandler;
import de.tudarmstadt.ukp.wikipedia.api.WikiConstants;
import de.tudarmstadt.ukp.wikipedia.api.Wikipedia;
import de.tudarmstadt.ukp.wikipedia.api.exception.WikiApiException;
import de.tudarmstadt.ukp.wikipedia.api.exception.WikiPageNotFoundException;
import de.tudarmstadt.ukp.wikipedia.api.exception.WikiTitleParsingException;
import de.tudarmstadt.ukp.wikipedia.api.util.GraphSerialization;
import de.tudarmstadt.ukp.wikipedia.util.ApiUtilities;
import de.tudarmstadt.ukp.wikipedia.util.CommonUtilities;
import de.tudarmstadt.ukp.wikipedia.util.OS;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jgrapht.DirectedGraph;
import org.jgrapht.UndirectedGraph;
import org.jgrapht.alg.ConnectivityInspector;
import org.jgrapht.alg.DijkstraShortestPath;
import org.jgrapht.graph.AsUndirectedGraph;
import org.jgrapht.graph.DefaultDirectedGraph;
import org.jgrapht.graph.DefaultEdge;

public class CategoryGraph
implements WikiConstants,
Serializable {
    private final Log logger = LogFactory.getLog(this.getClass());
    static final long serialVersionUID = 1L;
    private Wikipedia wiki;
    private DirectedGraph<Integer, DefaultEdge> graph;
    private UndirectedGraph<Integer, DefaultEdge> undirectedGraph;
    private Map<Integer, Integer> degreeDistribution;
    private int numberOfNodes;
    private int numberOfEdges;
    private Map<Integer, Integer> hyponymCountMap = null;
    private String hyponymCountMapFilename = "hypoCountMap";
    private Map<Integer, List<Integer>> rootPathMap = null;
    private String rootPathMapFilename = "rootPathMap";
    private double averageShortestPathLength = Double.NEGATIVE_INFINITY;
    private double diameter = Double.NEGATIVE_INFINITY;
    private double averageDegree = Double.NEGATIVE_INFINITY;
    private double clusterCoefficient = Double.NEGATIVE_INFINITY;
    private double depth = Double.NEGATIVE_INFINITY;

    public CategoryGraph() throws WikiApiException {
        this.logger.warn((Object)"Attention. You created an empty category graph. Intentionally?");
    }

    public CategoryGraph(Wikipedia pWiki, File location) throws WikiApiException {
        try {
            this.constructCategoryGraph(pWiki, GraphSerialization.loadGraph(location));
        }
        catch (IOException e) {
            throw new WikiApiException(e);
        }
        catch (ClassNotFoundException e) {
            throw new WikiApiException(e);
        }
    }

    public CategoryGraph(Wikipedia pWiki) throws WikiApiException {
        this.constructCategoryGraph(pWiki, pWiki.__getCategories(), null);
    }

    public CategoryGraph(Wikipedia pWiki, List<String> filterList) throws WikiApiException {
        this.constructCategoryGraph(pWiki, pWiki.__getCategories(), filterList);
    }

    public CategoryGraph(Wikipedia pWiki, Iterable<Category> categories) throws WikiApiException {
        HashSet<Integer> pageIDs = new HashSet<Integer>();
        while (categories.iterator().hasNext()) {
            pageIDs.add(categories.iterator().next().getPageId());
        }
        this.constructCategoryGraph(pWiki, pageIDs, null);
    }

    public CategoryGraph(Wikipedia pWiki, Iterable<Category> categories, List<String> filterList) throws WikiApiException {
        HashSet<Integer> pageIDs = new HashSet<Integer>();
        while (categories.iterator().hasNext()) {
            pageIDs.add(categories.iterator().next().getPageId());
        }
        this.constructCategoryGraph(pWiki, pageIDs, filterList);
    }

    protected CategoryGraph(Wikipedia pWiki, Set<Integer> pPageIDs) throws WikiApiException {
        this.constructCategoryGraph(pWiki, pPageIDs, null);
    }

    public CategoryGraph(Wikipedia pWiki, DirectedGraph<Integer, DefaultEdge> pGraph) throws WikiApiException {
        this.constructCategoryGraph(pWiki, pGraph);
    }

    private void constructCategoryGraph(Wikipedia pWiki, DirectedGraph<Integer, DefaultEdge> pGraph) throws WikiApiException {
        this.wiki = pWiki;
        this.graph = pGraph;
        this.numberOfNodes = this.graph.vertexSet().size();
        this.numberOfEdges = this.graph.edgeSet().size();
        this.undirectedGraph = new AsUndirectedGraph(this.graph);
    }

    private void constructCategoryGraph(Wikipedia pWiki, Set<Integer> pPageIDs, List<String> filterList) throws WikiApiException {
        this.graph = new DefaultDirectedGraph(DefaultEdge.class);
        this.wiki = pWiki;
        this.degreeDistribution = new HashMap<Integer, Integer>();
        for (int pageID : pPageIDs) {
            if (filterList != null) {
                Category cat;
                long hibernateID = pWiki.__getCategoryHibernateId(pageID);
                if (hibernateID == -1L) {
                    throw new WikiApiException(pageID + " is not a valid pageID");
                }
                try {
                    cat = new Category(this.wiki, hibernateID);
                }
                catch (WikiPageNotFoundException e) {
                    throw new WikiApiException("Category not found");
                }
                if (this.matchesFilter(cat, filterList)) continue;
            }
            this.graph.addVertex((Object)pageID);
        }
        this.numberOfNodes = this.graph.vertexSet().size();
        this.logger.info((Object)(OS.getUsedMemory() + " MB memory used."));
        int progress = 0;
        Iterator i$ = this.graph.vertexSet().iterator();
        while (i$.hasNext()) {
            Category cat;
            int pageID = (Integer)i$.next();
            ApiUtilities.printProgressInfo(++progress, pPageIDs.size(), 10, ApiUtilities.ProgressInfoMode.TEXT, "Adding edges");
            long hibernateID = pWiki.__getCategoryHibernateId(pageID);
            if (hibernateID == -1L) {
                throw new WikiApiException(pageID + " is not a valid pageID");
            }
            try {
                cat = new Category(this.wiki, hibernateID);
            }
            catch (WikiPageNotFoundException e) {
                throw new WikiApiException("Category not found");
            }
            Set<Integer> inLinks = cat.getParentIDs();
            Set<Integer> outLinks = cat.getChildrenIDs();
            for (int inLink : inLinks) {
                if (!this.graph.vertexSet().contains(inLink)) continue;
                if (inLink == pageID) {
                    this.logger.debug((Object)("Self-loop for node " + pageID + " (" + cat.getTitle() + ")"));
                    continue;
                }
                this.graph.addEdge((Object)inLink, (Object)pageID);
            }
            for (int outLink : outLinks) {
                if (!this.graph.vertexSet().contains(outLink)) continue;
                if (outLink == pageID) {
                    this.logger.debug((Object)("Self-loop for node " + pageID + " (" + cat.getTitle() + ")"));
                    continue;
                }
                this.graph.addEdge((Object)pageID, (Object)outLink);
            }
        }
        this.numberOfEdges = this.graph.edgeSet().size();
        this.logger.info((Object)("Added " + this.getNumberOfNodes() + " nodes."));
        this.logger.info((Object)("Added " + this.getNumberOfEdges() + " edges."));
        CycleHandler cycleHandler = new CycleHandler(this.wiki, this);
        this.logger.info((Object)("Graph contains cycles: " + cycleHandler.containsCycle()));
        cycleHandler.removeCycles();
        this.logger.info((Object)("Graph contains cycles: " + cycleHandler.containsCycle()));
        this.numberOfEdges = this.graph.edgeSet().size();
        this.undirectedGraph = new AsUndirectedGraph(this.graph);
    }

    private boolean matchesFilter(Category cat, List<String> filterList) throws WikiTitleParsingException {
        String categoryTitle = cat.getTitle().getPlainTitle();
        for (String filter : filterList) {
            if (!categoryTitle.startsWith(filter)) continue;
            this.logger.info((Object)(categoryTitle + " starts with " + filter + " => removing"));
            return true;
        }
        return false;
    }

    public Category getLCS(Category category1, Category category2) throws WikiApiException {
        int node2;
        int node1 = category1.getPageId();
        if (node1 == (node2 = category2.getPageId())) {
            return this.wiki.getCategory(node1);
        }
        List<Integer> nodeList1 = this.getRootPathMap().get(node1);
        List<Integer> nodeList2 = this.getRootPathMap().get(node2);
        if (nodeList1 == null || nodeList2 == null || nodeList1.size() == 0 || nodeList2.size() == 0) {
            this.logger.debug((Object)"One of the node lists is null or empty!");
            return null;
        }
        this.logger.debug(nodeList1);
        this.logger.debug(nodeList2);
        for (int tmpNode2 : nodeList2) {
            if (tmpNode2 != node1) continue;
            return this.wiki.getCategory(node1);
        }
        for (int tmpNode1 : nodeList1) {
            if (tmpNode1 != node2) continue;
            return this.wiki.getCategory(node2);
        }
        for (int tmpNode1 : nodeList1) {
            for (int tmpNode2 : nodeList2) {
                if (tmpNode1 != tmpNode2) continue;
                return this.wiki.getCategory(tmpNode1);
            }
        }
        this.logger.debug((Object)"No lcs found.");
        return null;
    }

    private List<Integer> getPathToRoot(int root, int node) throws WikiApiException {
        LinkedList<Integer> pathToRoot = new LinkedList<Integer>();
        ArrayList<Integer> shortestPath = new ArrayList<Integer>();
        this.expandPath(root, node, pathToRoot, shortestPath);
        if (shortestPath.size() == 0) {
            return null;
        }
        return shortestPath;
    }

    private void expandPath(int root, int currentNode, List<Integer> currentPath, List<Integer> shortestPath) {
        currentPath.add(currentNode);
        if (currentNode == root) {
            this.logger.debug((Object)"found root");
            if (shortestPath.size() != 0) {
                if (currentPath.size() < shortestPath.size()) {
                    this.logger.debug((Object)"setting new shortest path");
                    shortestPath.clear();
                    shortestPath.addAll(currentPath);
                }
            } else {
                this.logger.debug((Object)"initializing shortest path");
                shortestPath.addAll(currentPath);
            }
        }
        if (shortestPath.size() != 0 && currentPath.size() >= shortestPath.size()) {
            return;
        }
        Set incomingEdges = this.graph.incomingEdgesOf((Object)currentNode);
        if (incomingEdges == null || incomingEdges.size() == 0) {
            this.logger.debug((Object)"found non-root source");
            return;
        }
        for (DefaultEdge incomingEdge : incomingEdges) {
            int sourceNode = (Integer)this.graph.getEdgeSource((Object)incomingEdge);
            if (sourceNode == currentNode) {
                this.logger.warn((Object)"Source node equals current node.");
                System.exit(1);
            }
            LinkedList<Integer> savedPath = new LinkedList<Integer>(currentPath);
            this.expandPath(root, sourceNode, currentPath, shortestPath);
            currentPath.clear();
            currentPath.addAll(savedPath);
        }
    }

    public int getPathLengthInEdges(Category node1, Category node2) {
        if (this.graph.containsVertex((Object)node1.getPageId()) && this.graph.containsVertex((Object)node2.getPageId())) {
            if (node1.getPageId() == node2.getPageId()) {
                return 0;
            }
            List edgeList = DijkstraShortestPath.findPathBetween(this.undirectedGraph, (Object)node1.getPageId(), (Object)node2.getPageId());
            if (edgeList == null) {
                return -1;
            }
            return edgeList.size();
        }
        return -1;
    }

    public int getTaxonomicallyBoundPathLengthInEdges(Category cat1, Category cat2) throws WikiApiException {
        int node1 = cat1.getPageId();
        int node2 = cat2.getPageId();
        if (!this.graph.containsVertex((Object)node1) || !this.graph.containsVertex((Object)node2)) {
            return -1;
        }
        if (node1 == node2) {
            return 0;
        }
        List<Integer> nodeList1 = this.getRootPathMap().get(node1);
        List<Integer> nodeList2 = this.getRootPathMap().get(node2);
        if (nodeList1 == null || nodeList2 == null || nodeList1.size() == 0 || nodeList2.size() == 0) {
            this.logger.debug((Object)"One of the node lists is null or empty!");
            return -1;
        }
        this.logger.debug(nodeList1);
        this.logger.debug(nodeList2);
        int distance1 = 0;
        for (int tmpNode2 : nodeList2) {
            if (tmpNode2 == node1) {
                return distance1;
            }
            ++distance1;
        }
        int distance2 = 0;
        for (int tmpNode1 : nodeList1) {
            if (tmpNode1 == node2) {
                return distance2;
            }
            ++distance2;
        }
        distance1 = 0;
        for (int tmpNode1 : nodeList1) {
            distance2 = 0;
            for (int tmpNode2 : nodeList2) {
                if (tmpNode1 == tmpNode2) {
                    return distance1 + distance2;
                }
                ++distance2;
            }
            ++distance1;
        }
        return -1;
    }

    public int getTaxonomicallyBoundPathLengthInNodes(Category cat1, Category cat2) throws WikiApiException {
        int retValue = this.getTaxonomicallyBoundPathLengthInEdges(cat1, cat2);
        if (retValue == 0) {
            return 0;
        }
        if (retValue > 0) {
            return --retValue;
        }
        if (retValue == -1) {
            return -1;
        }
        throw new WikiApiException("Unknown return value.");
    }

    public int getPathLengthInNodes(Category node1, Category node2) throws WikiApiException {
        int retValue = this.getPathLengthInEdges(node1, node2);
        if (retValue == 0) {
            return 0;
        }
        if (retValue > 0) {
            return --retValue;
        }
        if (retValue == -1) {
            return -1;
        }
        throw new WikiApiException("Unknown return value.");
    }

    private void createHyponymCountMap() throws WikiApiException {
        if (this.hyponymCountMap != null) {
            return;
        }
        File hyponymCountMapSerializedFile = new File(this.wiki.getWikipediaId() + "_" + this.hyponymCountMapFilename);
        this.hyponymCountMap = new HashMap<Integer, Integer>();
        if (hyponymCountMapSerializedFile.exists()) {
            this.logger.info((Object)"Loading saved hyponymyCountMap ...");
            this.hyponymCountMap = this.deserializeMap(hyponymCountMapSerializedFile);
            this.logger.info((Object)"Done loading saved hyponymyCountMap");
            return;
        }
        ArrayList<Integer> queue = new ArrayList<Integer>();
        HashSet<Integer> visited = new HashSet<Integer>();
        Set<Integer> leafNodes = this.__getLeafNodes();
        queue.addAll(leafNodes);
        this.logger.info((Object)(leafNodes.size() + " leaf nodes."));
        while (!queue.isEmpty()) {
            int currNode = (Integer)queue.get(0);
            queue.remove(0);
            if (visited.contains(currNode)) continue;
            Set<Integer> children = this.__getChildren(currNode);
            int validChildren = 0;
            int sumChildHyponyms = 0;
            boolean invalid = false;
            for (int child : children) {
                if (!this.graph.containsVertex((Object)child)) continue;
                if (this.hyponymCountMap.containsKey(child)) {
                    sumChildHyponyms += this.hyponymCountMap.get(child).intValue();
                    ++validChildren;
                    continue;
                }
                invalid = true;
            }
            if (invalid) {
                queue.add(currNode);
                continue;
            }
            visited.add(currNode);
            int currNodeHyponomyCount = validChildren + sumChildHyponyms;
            this.hyponymCountMap.put(currNode, currNodeHyponomyCount);
            for (int parent : this.__getParents(currNode)) {
                if (!this.graph.containsVertex((Object)parent)) continue;
                queue.add(parent);
            }
        }
        this.logger.info((Object)(visited.size() + " nodes visited"));
        if (visited.size() != this.graph.vertexSet().size()) {
            throw new WikiApiException("Visited only " + visited.size() + " out of " + this.graph.vertexSet().size() + " nodes.");
        }
        if (this.hyponymCountMap.size() != this.graph.vertexSet().size()) {
            throw new WikiApiException("HyponymCountMap does not contain an entry for each node in the graph." + this.hyponymCountMap.size() + "/" + this.graph.vertexSet().size());
        }
        this.scaleHyponymCountMap();
        this.logger.info((Object)"Computed hyponymCountMap");
        this.serializeMap(this.hyponymCountMap, hyponymCountMapSerializedFile);
        this.logger.info((Object)"Serialized hyponymCountMap");
    }

    private void scaleHyponymCountMap() throws WikiApiException {
        for (int key : this.getHyponymCountMap().keySet()) {
            if (this.getHyponymCountMap().get(key) <= this.graph.vertexSet().size()) continue;
            this.getHyponymCountMap().put(key, this.graph.vertexSet().size() - 1);
        }
    }

    protected Set<Integer> __getLeafNodes() throws WikiApiException {
        HashSet<Integer> leafNodes = new HashSet<Integer>();
        Iterator i$ = this.graph.vertexSet().iterator();
        while (i$.hasNext()) {
            int node = (Integer)i$.next();
            if (this.getOutDegree(node) != 0) continue;
            leafNodes.add(node);
        }
        return leafNodes;
    }

    public double getIntrinsicInformationContent(Category category) throws WikiApiException {
        int numberOfNodes;
        int node = category.getPageId();
        int hyponymCount = this.getHyponymCountMap().get(node);
        if (hyponymCount > (numberOfNodes = this.getNumberOfNodes())) {
            throw new WikiApiException("Something is wrong with the hyponymCountMap. " + hyponymCount + " hyponyms, but only " + numberOfNodes + " nodes.");
        }
        this.logger.debug((Object)(category.getTitle().getPlainTitle() + " has # hyponyms: " + hyponymCount));
        double intrinsicIC = -1.0;
        if (hyponymCount >= 0) {
            intrinsicIC = 1.0 - Math.log(hyponymCount + 1) / Math.log(numberOfNodes);
        }
        return intrinsicIC;
    }

    public void createRootPathMap() throws WikiApiException {
        if (this.rootPathMap != null) {
            return;
        }
        File rootPathFile = new File(this.wiki.getWikipediaId() + "_" + this.rootPathMapFilename);
        if (rootPathFile.exists()) {
            this.logger.info((Object)"Loading saved rootPathMap ...");
            this.rootPathMap = this.deserializeMap(rootPathFile);
            this.logger.info((Object)"Done loading saved rootPathMap");
            return;
        }
        this.logger.info((Object)"Computing rootPathMap");
        this.rootPathMap = new HashMap<Integer, List<Integer>>();
        ArrayList<Integer> queue = new ArrayList<Integer>();
        Set<Integer> leafNodes = this.__getLeafNodes();
        queue.addAll(leafNodes);
        this.logger.info((Object)(queue.size() + " leaf nodes."));
        this.fillRootPathMap(queue);
        queue.clear();
        for (Category cat : this.wiki.getCategories()) {
            if (this.rootPathMap.containsKey(cat.getPageId())) continue;
            queue.add(cat.getPageId());
        }
        this.logger.info((Object)(queue.size() + " non leaf nodes not on a shortest leaf-node to root path."));
        this.fillRootPathMap(queue);
        for (Category cat : this.wiki.getCategories()) {
            if (this.rootPathMap.containsKey(cat.getPageId())) continue;
            this.logger.info((Object)("no path for " + cat.getPageId()));
        }
        this.depth = this.getDepthFromRootPathMap();
        this.logger.info((Object)("Setting depth of category graph: " + this.depth));
        this.logger.info((Object)"Serializing rootPathMap");
        this.serializeMap(this.rootPathMap, rootPathFile);
    }

    public void deleteRootPathMap() throws WikiApiException {
        File rootPathFile = new File(this.rootPathMapFilename + "_" + (Object)((Object)this.wiki.getLanguage()) + "_" + this.wiki.getMetaData().getVersion());
        rootPathFile.delete();
    }

    private void fillRootPathMap(List<Integer> queue) throws WikiApiException {
        int root = this.wiki.getMetaData().getMainCategory().getPageId();
        while (!queue.isEmpty()) {
            int currentNode = queue.get(0);
            queue.remove(0);
            this.logger.debug((Object)("Queue size: " + queue.size()));
            if (this.getRootPathMap().containsKey(currentNode)) continue;
            List<Integer> nodesOnPath = this.getPathToRoot(root, currentNode);
            if (nodesOnPath == null) {
                this.getRootPathMap().put(currentNode, new ArrayList());
                continue;
            }
            if (nodesOnPath.get(0) != currentNode || nodesOnPath.get(nodesOnPath.size() - 1) != root) {
                this.logger.error((Object)"Something is wrong with the path to the root");
                this.logger.error((Object)(nodesOnPath.get(0) + " -- " + currentNode));
                this.logger.error((Object)(nodesOnPath.get(nodesOnPath.size() - 1) + " -- " + root));
                this.logger.error((Object)nodesOnPath.size());
                System.exit(1);
            }
            int i = 0;
            for (int nodeOnPath : nodesOnPath) {
                if (this.getRootPathMap().containsKey(nodeOnPath)) continue;
                this.getRootPathMap().put(nodeOnPath, new ArrayList<Integer>(nodesOnPath.subList(i, nodesOnPath.size())));
                ++i;
            }
        }
    }

    protected int getInDegree(int pageID) throws WikiApiException {
        return this.graph.inDegreeOf((Object)pageID);
    }

    protected int getOutDegree(int pageID) throws WikiApiException {
        return this.graph.outDegreeOf((Object)pageID);
    }

    protected Set<Integer> __getChildren(int pageID) throws WikiApiException {
        Set outgoingEdges = this.graph.outgoingEdgesOf((Object)pageID);
        HashSet<Integer> outLinks = new HashSet<Integer>();
        for (DefaultEdge edge : outgoingEdges) {
            outLinks.add((Integer)this.graph.getEdgeTarget((Object)edge));
        }
        return outLinks;
    }

    protected Set<Integer> __getParents(int pageID) throws WikiApiException {
        Set incomingEdges = this.graph.incomingEdgesOf((Object)pageID);
        HashSet<Integer> inLinks = new HashSet<Integer>();
        for (DefaultEdge edge : incomingEdges) {
            inLinks.add((Integer)this.graph.getEdgeSource((Object)edge));
        }
        return inLinks;
    }

    public CategoryGraph getLargestConnectedComponent() throws WikiApiException {
        ConnectivityInspector connectInspect = new ConnectivityInspector(this.graph);
        if (connectInspect.isGraphConnected()) {
            return this;
        }
        List connectedComponentList = connectInspect.connectedSets();
        this.logger.info((Object)(connectedComponentList.size() + " connected components."));
        int i = 0;
        int maxSize = 0;
        Set<Integer> largestComponent = new HashSet();
        for (Set connectedComponent : connectedComponentList) {
            ++i;
            if (connectedComponent.size() <= maxSize) continue;
            maxSize = connectedComponent.size();
            largestComponent = connectedComponent;
        }
        double largestComponentRatio = largestComponent.size() * 100 / this.getNumberOfNodes();
        this.logger.info((Object)("Largest component contains " + largestComponentRatio + "% (" + largestComponent.size() + "/" + this.getNumberOfNodes() + ") of the nodes in the graph."));
        return CategoryGraphManager.getCategoryGraph(this.wiki, largestComponent);
    }

    public int getNumberOfNodes() {
        return this.numberOfNodes;
    }

    public int getNumberOfEdges() {
        return this.numberOfEdges;
    }

    public double getAverageShortestPathLength() {
        if (this.averageShortestPathLength < 0.0) {
            this.logger.debug((Object)"Calling setGraphParameters");
            this.setGraphParameters();
        }
        return this.averageShortestPathLength;
    }

    public double getDiameter() {
        if (this.diameter < 0.0) {
            this.logger.debug((Object)"Calling setGraphParameters");
            this.setGraphParameters();
        }
        return this.diameter;
    }

    public double getAverageDegree() {
        if (this.averageDegree < 0.0) {
            this.logger.debug((Object)"Calling setGraphParameters");
            this.setGraphParameters();
        }
        return this.averageDegree;
    }

    public double getClusterCoefficient() {
        if (this.clusterCoefficient < 0.0) {
            this.logger.debug((Object)"Calling setGraphParameters");
            this.setGraphParameters();
        }
        return this.clusterCoefficient;
    }

    public Map<Integer, Integer> getDegreeDistribution() {
        if (this.degreeDistribution == null) {
            this.logger.debug((Object)"Calling setGraphParameters");
            this.setGraphParameters();
        }
        return this.degreeDistribution;
    }

    private int getNumberOfNeighborConnections(int node) {
        int numberOfConnections = 0;
        Set<Integer> neighbors = this.getNeighbors(node);
        if (neighbors.size() > 0) {
            Object[] nodeArray = neighbors.toArray();
            Arrays.sort(nodeArray);
            for (int i = 0; i < neighbors.size(); ++i) {
                int outerNode = (Integer)nodeArray[i];
                for (int j = i + 1; j < neighbors.size(); ++j) {
                    int innerNode = (Integer)nodeArray[j];
                    if (!this.undirectedGraph.containsEdge((Object)innerNode, (Object)outerNode)) continue;
                    ++numberOfConnections;
                }
            }
        }
        return numberOfConnections;
    }

    protected Set<Integer> getNeighbors(int node) {
        HashSet<Integer> neighbors = new HashSet<Integer>();
        Set edges = this.undirectedGraph.edgesOf((Object)node);
        for (DefaultEdge edge : edges) {
            if ((Integer)this.undirectedGraph.getEdgeSource((Object)edge) != node) {
                neighbors.add((Integer)this.undirectedGraph.getEdgeSource((Object)edge));
            }
            if ((Integer)this.undirectedGraph.getEdgeTarget((Object)edge) == node) continue;
            neighbors.add((Integer)this.undirectedGraph.getEdgeTarget((Object)edge));
        }
        return neighbors;
    }

    private void updateDegreeDistribution(int nodeDegree) {
        if (this.degreeDistribution.containsKey(nodeDegree)) {
            this.degreeDistribution.put(nodeDegree, this.degreeDistribution.get(nodeDegree) + 1);
        } else {
            this.degreeDistribution.put(nodeDegree, 1);
        }
    }

    private void setGraphParameters() {
        double maxPathLength = 0.0;
        double shortestPathLengthSum = 0.0;
        double degreeSum = 0.0;
        double clusterCoefficientSum = 0.0;
        Set nodes = this.undirectedGraph.vertexSet();
        HashSet<Integer> wasSource = new HashSet<Integer>();
        int progress = 0;
        Iterator i$ = nodes.iterator();
        while (i$.hasNext()) {
            int node = (Integer)i$.next();
            ApiUtilities.printProgressInfo(++progress, nodes.size(), 100, ApiUtilities.ProgressInfoMode.TEXT, "Getting graph parameters");
            int nodeDegree = this.undirectedGraph.degreeOf((Object)node);
            degreeSum += (double)nodeDegree;
            this.updateDegreeDistribution(nodeDegree);
            if (this.undirectedGraph.degreeOf((Object)node) > 1) {
                double numberOfNeighborConnections = this.getNumberOfNeighborConnections(node);
                clusterCoefficientSum += numberOfNeighborConnections / (double)(nodeDegree * (nodeDegree - 1));
            }
            double[] returnValues = this.computeShortestPathLenghts(node, shortestPathLengthSum, maxPathLength, wasSource);
            shortestPathLengthSum = returnValues[0];
            maxPathLength = returnValues[1];
            wasSource.add(node);
        }
        this.averageShortestPathLength = nodes.size() > 1 ? shortestPathLengthSum / (double)(nodes.size() * (nodes.size() - 1) / 2) : 0.0;
        this.diameter = maxPathLength;
        this.averageDegree = degreeSum / (double)nodes.size();
        this.clusterCoefficient = clusterCoefficientSum / (double)nodes.size();
    }

    private double[] computeShortestPathLenghts(int pStartNode, double pShortestPathLengthSum, double pMaxPathLength, Set<Integer> pWasSource) {
        HashSet<Integer> alreadyExpanded = new HashSet<Integer>();
        ArrayList<int[]> queue = new ArrayList<int[]>();
        int[] innerList = new int[]{pStartNode, 0};
        queue.add(innerList);
        while (!queue.isEmpty()) {
            int[] queueElement = (int[])queue.get(0);
            int currentNode = queueElement[0];
            int distance = queueElement[1];
            queue.remove(0);
            if (alreadyExpanded.contains(currentNode)) continue;
            alreadyExpanded.add(currentNode);
            if (!pWasSource.contains(currentNode)) {
                pShortestPathLengthSum += (double)distance;
                if ((double)distance > pMaxPathLength) {
                    pMaxPathLength = distance;
                }
            }
            Set<Integer> neighbors = this.getNeighbors(currentNode);
            for (int neighbor : neighbors) {
                if (alreadyExpanded.contains(neighbor)) continue;
                int[] tmpList = new int[]{neighbor, distance + 1};
                queue.add(tmpList);
            }
        }
        double[] returnArray = new double[]{pShortestPathLengthSum, pMaxPathLength};
        return returnArray;
    }

    public double getDepth() throws WikiApiException {
        if (this.depth < 0.0) {
            if (this.rootPathMap != null) {
                this.depth = this.getDepthFromRootPathMap();
                this.logger.info((Object)("Getting depth from RootPathMap: " + this.depth));
            } else {
                this.depth = this.computeDepth();
                this.logger.info((Object)("Computing depth of the hierarchy: " + this.depth));
            }
        }
        return this.depth;
    }

    private double getDepthFromRootPathMap() throws WikiApiException {
        int max = 0;
        for (List<Integer> path : this.getRootPathMap().values()) {
            if (path.size() <= max) continue;
            max = path.size();
        }
        if (--max < 0) {
            return 0.0;
        }
        return max;
    }

    private double computeDepth() throws WikiApiException {
        Category root = this.wiki.getMetaData().getMainCategory();
        if (root == null) {
            this.logger.error((Object)"There is no root node for this wiki. Check the parameter that provides the name of the root node.");
            return 0.0;
        }
        if (!this.graph.containsVertex((Object)root.getPageId())) {
            this.logger.error((Object)"The root node is not part of this graph. Cannot compute depth of this graph. Setting depth to 0.0");
            return 0.0;
        }
        double maxPathLength = 0.0;
        double[] returnValues = this.computeShortestPathLenghts(root.getPageId(), 0.0, maxPathLength, new HashSet<Integer>());
        maxPathLength = returnValues[1];
        return maxPathLength;
    }

    public String getGraphInfo() {
        StringBuffer sb = new StringBuffer(1000);
        Map<Integer, Integer> degreeDistribution = this.getDegreeDistribution();
        sb.append("Number of Nodes:     " + this.getNumberOfNodes() + LF);
        sb.append("Number of Edges:     " + this.getNumberOfEdges() + LF);
        sb.append("Avg. path length:    " + this.getAverageShortestPathLength() + LF);
        sb.append("Diameter:            " + this.getDiameter() + LF);
        sb.append("Average degree:      " + this.getAverageDegree() + LF);
        sb.append("Cluster coefficient: " + this.getClusterCoefficient() + LF);
        sb.append("Degree distribution: " + CommonUtilities.getMapContents(degreeDistribution) + LF);
        return sb.toString();
    }

    public DirectedGraph<Integer, DefaultEdge> getGraph() {
        return this.graph;
    }

    protected Map<Integer, Integer> getHyponymCountMap() throws WikiApiException {
        if (this.hyponymCountMap == null) {
            this.createHyponymCountMap();
        }
        return this.hyponymCountMap;
    }

    protected Map<Integer, List<Integer>> getRootPathMap() throws WikiApiException {
        if (this.rootPathMap == null) {
            this.createRootPathMap();
        }
        return this.rootPathMap;
    }

    private void serializeMap(Map<?, ?> map, File file) {
        try {
            ObjectOutputStream os = new ObjectOutputStream(new FileOutputStream(file));
            os.writeObject(map);
            os.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private Map deserializeMap(File file) {
        Map map;
        try {
            ObjectInputStream is = new ObjectInputStream(new FileInputStream(file));
            map = (Map)is.readObject();
            is.close();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
        return map;
    }

    public void saveGraph(String destination) throws WikiApiException {
        try {
            GraphSerialization.saveGraph(this.graph, destination);
        }
        catch (IOException e) {
            throw new WikiApiException(e);
        }
    }
}

