/*
 * Decompiled with CFR 0.152.
 */
package de.tudarmstadt.ukp.wikipedia.api;

import de.tudarmstadt.ukp.wikipedia.api.Category;
import de.tudarmstadt.ukp.wikipedia.api.Wikipedia;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class CategoryDescendantsIterator
implements Iterator<Category> {
    private final Log logger = LogFactory.getLog(this.getClass());
    private Wikipedia wiki;
    private CategoryBuffer buffer;
    private Set<Integer> notExpandedCategories;
    private Set<Integer> expandedCategoryIds;

    public CategoryDescendantsIterator(Wikipedia wiki, int bufferSize, Category startCategory) {
        this.wiki = wiki;
        this.buffer = new CategoryBuffer(bufferSize);
        this.notExpandedCategories = new HashSet<Integer>();
        for (Category catItem : startCategory.getChildren()) {
            this.notExpandedCategories.add(catItem.getPageId());
        }
        this.expandedCategoryIds = new HashSet<Integer>();
    }

    @Override
    public boolean hasNext() {
        return this.buffer.hasNext();
    }

    @Override
    public Category next() {
        return this.buffer.next();
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    class CategoryBuffer {
        private List<Category> buffer;
        private int maxBufferSize;
        private int bufferFillSize;
        private int bufferOffset;
        private int dataOffset;

        public CategoryBuffer(int bufferSize) {
            this.maxBufferSize = bufferSize;
            this.buffer = new ArrayList<Category>();
            this.bufferFillSize = 0;
            this.bufferOffset = 0;
            this.dataOffset = 0;
        }

        public boolean hasNext() {
            if (this.bufferOffset < this.bufferFillSize) {
                return true;
            }
            return this.fillBuffer();
        }

        public Category next() {
            if (this.bufferOffset < this.bufferFillSize) {
                return this.getBufferElement();
            }
            if (this.fillBuffer()) {
                return this.getBufferElement();
            }
            return null;
        }

        private Category getBufferElement() {
            Category cat = this.buffer.get(this.bufferOffset);
            ++this.bufferOffset;
            ++this.dataOffset;
            return cat;
        }

        private boolean fillBuffer() {
            this.buffer.clear();
            this.bufferOffset = 0;
            this.bufferFillSize = 0;
            LinkedList<Integer> queue = new LinkedList<Integer>();
            queue.addAll(CategoryDescendantsIterator.this.notExpandedCategories);
            while (!queue.isEmpty() && this.buffer.size() < this.maxBufferSize) {
                Category currentCat = CategoryDescendantsIterator.this.wiki.getCategory((Integer)queue.get(0));
                queue.remove(0);
                if (CategoryDescendantsIterator.this.expandedCategoryIds.contains(currentCat.getPageId())) continue;
                this.buffer.add(currentCat);
                CategoryDescendantsIterator.this.notExpandedCategories.remove(currentCat.getPageId());
                CategoryDescendantsIterator.this.expandedCategoryIds.add(currentCat.getPageId());
                CategoryDescendantsIterator.this.logger.debug((Object)("buf: " + this.buffer.size()));
                CategoryDescendantsIterator.this.logger.debug((Object)("notExp: " + CategoryDescendantsIterator.this.notExpandedCategories));
                CategoryDescendantsIterator.this.logger.debug((Object)("exp: " + CategoryDescendantsIterator.this.expandedCategoryIds));
                for (Category child : currentCat.getChildren()) {
                    queue.add(child.getPageId());
                    CategoryDescendantsIterator.this.notExpandedCategories.add(child.getPageId());
                }
            }
            if (this.buffer.size() > 0) {
                this.bufferFillSize = this.buffer.size();
                return true;
            }
            return false;
        }
    }
}

