/*
 * Decompiled with CFR 0.152.
 */
package de.tudarmstadt.ukp.wikipedia.api;

import de.tudarmstadt.ukp.wikipedia.api.CategoryDescendantsIterable;
import de.tudarmstadt.ukp.wikipedia.api.Page;
import de.tudarmstadt.ukp.wikipedia.api.Title;
import de.tudarmstadt.ukp.wikipedia.api.WikiConstants;
import de.tudarmstadt.ukp.wikipedia.api.Wikipedia;
import de.tudarmstadt.ukp.wikipedia.api.exception.WikiApiException;
import de.tudarmstadt.ukp.wikipedia.api.exception.WikiPageNotFoundException;
import de.tudarmstadt.ukp.wikipedia.api.exception.WikiTitleParsingException;
import de.tudarmstadt.ukp.wikipedia.api.hibernate.CategoryDAO;
import java.math.BigInteger;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.hibernate.LockMode;
import org.hibernate.Session;

public class Category
implements WikiConstants {
    private CategoryDAO catDAO;
    private de.tudarmstadt.ukp.wikipedia.api.hibernate.Category hibernateCategory;
    private Wikipedia wiki;

    protected Category(Wikipedia wiki, long id) throws WikiPageNotFoundException {
        this.wiki = wiki;
        this.catDAO = new CategoryDAO(wiki);
        this.createCategory(id);
    }

    protected Category(Wikipedia wiki, int pageID) throws WikiPageNotFoundException {
        this.wiki = wiki;
        this.catDAO = new CategoryDAO(wiki);
        this.createCategory(pageID);
    }

    public Category(Wikipedia wiki, String pName) throws WikiApiException {
        if (pName == null || pName.length() == 0) {
            throw new WikiPageNotFoundException();
        }
        this.wiki = wiki;
        this.catDAO = new CategoryDAO(wiki);
        Title catTitle = new Title(pName);
        this.createCategory(catTitle);
    }

    private void createCategory(long id) throws WikiPageNotFoundException {
        Session session = this.wiki.__getHibernateSession();
        session.beginTransaction();
        this.hibernateCategory = this.catDAO.findById(id);
        session.getTransaction().commit();
        if (this.hibernateCategory == null) {
            throw new WikiPageNotFoundException("No category with id " + id + " was found.");
        }
    }

    private void createCategory(int pageID) throws WikiPageNotFoundException {
        this.createCategory(this.wiki.__getCategoryHibernateId(pageID));
    }

    private void createCategory(Title title) throws WikiPageNotFoundException {
        String name = title.getWikiStyleTitle();
        Session session = this.wiki.__getHibernateSession();
        session.beginTransaction();
        Object returnValue = session.createSQLQuery("select cat.pageId from Category as cat where cat.name = :name COLLATE utf8_bin").setString("name", name).uniqueResult();
        session.getTransaction().commit();
        if (returnValue == null) {
            this.hibernateCategory = null;
            throw new WikiPageNotFoundException("No category with name " + name + " was found.");
        }
        int pageID = (Integer)returnValue;
        this.createCategory(pageID);
    }

    public long __getId() {
        Session session = this.wiki.__getHibernateSession();
        session.beginTransaction();
        session.lock((Object)this.hibernateCategory, LockMode.NONE);
        long id = this.hibernateCategory.getId();
        session.getTransaction().commit();
        return id;
    }

    public int getPageId() {
        Session session = this.wiki.__getHibernateSession();
        session.beginTransaction();
        session.lock((Object)this.hibernateCategory, LockMode.NONE);
        int pageID = this.hibernateCategory.getPageId();
        session.getTransaction().commit();
        return pageID;
    }

    public Set<Category> getParents() {
        Session session = this.wiki.__getHibernateSession();
        session.beginTransaction();
        session.lock((Object)this.hibernateCategory, LockMode.NONE);
        HashSet<Integer> tmpSet = new HashSet<Integer>(this.hibernateCategory.getInLinks());
        session.getTransaction().commit();
        HashSet<Category> categories = new HashSet<Category>();
        Iterator i$ = tmpSet.iterator();
        while (i$.hasNext()) {
            int pageID = (Integer)i$.next();
            categories.add(this.wiki.getCategory(pageID));
        }
        return categories;
    }

    public int getNumberOfParents() {
        BigInteger nrOfInlinks = new BigInteger("0");
        long id = this.__getId();
        Session session = this.wiki.__getHibernateSession();
        session.beginTransaction();
        Object returnValue = session.createSQLQuery("select count(inLinks) from category_inlinks where id = :id").setLong("id", id).uniqueResult();
        session.getTransaction().commit();
        if (returnValue != null) {
            nrOfInlinks = (BigInteger)returnValue;
        }
        return nrOfInlinks.intValue();
    }

    public Set<Integer> getParentIDs() {
        Session session = this.wiki.__getHibernateSession();
        session.beginTransaction();
        session.lock((Object)this.hibernateCategory, LockMode.NONE);
        HashSet<Integer> tmpSet = new HashSet<Integer>(this.hibernateCategory.getInLinks());
        session.getTransaction().commit();
        return tmpSet;
    }

    public Set<Category> getChildren() {
        Session session = this.wiki.__getHibernateSession();
        session.beginTransaction();
        session.lock((Object)this.hibernateCategory, LockMode.NONE);
        HashSet<Integer> tmpSet = new HashSet<Integer>(this.hibernateCategory.getOutLinks());
        session.getTransaction().commit();
        HashSet<Category> categories = new HashSet<Category>();
        Iterator i$ = tmpSet.iterator();
        while (i$.hasNext()) {
            int pageID = (Integer)i$.next();
            categories.add(this.wiki.getCategory(pageID));
        }
        return categories;
    }

    public int getNumberOfChildren() {
        BigInteger nrOfOutlinks = new BigInteger("0");
        long id = this.__getId();
        Session session = this.wiki.__getHibernateSession();
        session.beginTransaction();
        Object returnValue = session.createSQLQuery("select count(outLinks) from category_outlinks where id = :id").setLong("id", id).uniqueResult();
        session.getTransaction().commit();
        if (returnValue != null) {
            nrOfOutlinks = (BigInteger)returnValue;
        }
        return nrOfOutlinks.intValue();
    }

    public Set<Integer> getChildrenIDs() {
        Session session = this.wiki.__getHibernateSession();
        session.beginTransaction();
        session.lock((Object)this.hibernateCategory, LockMode.NONE);
        HashSet<Integer> tmpSet = new HashSet<Integer>(this.hibernateCategory.getOutLinks());
        session.getTransaction().commit();
        return tmpSet;
    }

    public Title getTitle() throws WikiTitleParsingException {
        Session session = this.wiki.__getHibernateSession();
        session.beginTransaction();
        session.lock((Object)this.hibernateCategory, LockMode.NONE);
        String name = this.hibernateCategory.getName();
        session.getTransaction().commit();
        Title title = new Title(name);
        return title;
    }

    @Deprecated
    public Set<Page> getPages() throws WikiApiException {
        Session session = this.wiki.__getHibernateSession();
        session.beginTransaction();
        session.lock((Object)this.hibernateCategory, LockMode.NONE);
        HashSet<Integer> tmpSet = new HashSet<Integer>(this.hibernateCategory.getPages());
        session.getTransaction().commit();
        HashSet<Page> pages = new HashSet<Page>();
        Iterator i$ = tmpSet.iterator();
        while (i$.hasNext()) {
            int pageID = (Integer)i$.next();
            pages.add(this.wiki.getPage(pageID));
        }
        return pages;
    }

    public Set<Page> getArticles() throws WikiApiException {
        Session session = this.wiki.__getHibernateSession();
        session.beginTransaction();
        session.lock((Object)this.hibernateCategory, LockMode.NONE);
        HashSet<Integer> tmpSet = new HashSet<Integer>(this.hibernateCategory.getPages());
        session.getTransaction().commit();
        HashSet<Page> pages = new HashSet<Page>();
        Iterator i$ = tmpSet.iterator();
        while (i$.hasNext()) {
            int pageID = (Integer)i$.next();
            pages.add(this.wiki.getPage(pageID));
        }
        return pages;
    }

    public Set<Integer> getArticleIds() throws WikiApiException {
        Session session = this.wiki.__getHibernateSession();
        session.beginTransaction();
        session.lock((Object)this.hibernateCategory, LockMode.NONE);
        HashSet<Integer> tmpSet = new HashSet<Integer>(this.hibernateCategory.getPages());
        session.getTransaction().commit();
        return tmpSet;
    }

    public int getNumberOfPages() throws WikiApiException {
        BigInteger nrOfPages = new BigInteger("0");
        long id = this.__getId();
        Session session = this.wiki.__getHibernateSession();
        session.beginTransaction();
        Object returnValue = session.createSQLQuery("select count(pages) from category_pages where id = :id").setLong("id", id).uniqueResult();
        session.getTransaction().commit();
        if (returnValue != null) {
            nrOfPages = (BigInteger)returnValue;
        }
        return nrOfPages.intValue();
    }

    protected Set<Integer> __getPages() throws WikiPageNotFoundException {
        Session session = this.wiki.__getHibernateSession();
        session.beginTransaction();
        session.lock((Object)this.hibernateCategory, LockMode.NONE);
        HashSet<Integer> tmpSet = new HashSet<Integer>(this.hibernateCategory.getPages());
        session.getTransaction().commit();
        return tmpSet;
    }

    public Iterable<Category> getDescendants() {
        return new CategoryDescendantsIterable(this.wiki, this);
    }

    protected Iterable<Category> getDescendants(int bufferSize) {
        return new CategoryDescendantsIterable(this.wiki, bufferSize, this);
    }

    public Set<Category> getSiblings() {
        HashSet<Category> siblings = new HashSet<Category>();
        for (Category parent : this.getParents()) {
            siblings.addAll(parent.getChildren());
        }
        siblings.remove(this);
        return siblings;
    }

    protected String getCategoryInfo() throws WikiApiException {
        StringBuffer sb = new StringBuffer(1000);
        sb.append("ID             : " + this.__getId() + LF);
        sb.append("PageID         : " + this.getPageId() + LF);
        sb.append("Name           : " + this.getTitle() + LF);
        sb.append("In-Links" + LF);
        for (Category parent : this.getParents()) {
            sb.append("  " + parent.getTitle() + LF);
        }
        sb.append("Out-Links" + LF);
        for (Category child : this.getChildren()) {
            sb.append("  " + child.getTitle() + LF);
        }
        sb.append("Pages" + LF);
        for (Page page : this.getPages()) {
            sb.append("  " + page.getTitle() + LF);
        }
        return sb.toString();
    }
}

