/*
 * Decompiled with CFR 0.152.
 */
package de.tudarmstadt.ukp.wikipedia.util;

import de.tudarmstadt.ukp.wikipedia.api.Page;
import java.util.HashSet;
import java.util.Random;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class GraphUtilities {
    private static final Log logger = LogFactory.getLog(GraphUtilities.class);

    public static Set<Integer> getRandomPageSubset(Iterable<Page> pages, int pResultSetSize) {
        HashSet<Integer> pageIDs = new HashSet<Integer>();
        while (pages.iterator().hasNext()) {
            pageIDs.add(pages.iterator().next().getPageId());
        }
        return GraphUtilities.getRandomPageSubset(pageIDs, pResultSetSize);
    }

    public static Set<Integer> getRandomPageSubset(Set<Integer> pPageIDs, int pResultSetSize) {
        HashSet<Integer> uniqueRandomSet = new HashSet<Integer>();
        if (pPageIDs.size() < pResultSetSize) {
            logger.error((Object)"Requested subset size is larger than the original page set size.");
            return null;
        }
        Random rand = new Random();
        Object[] pageIdArray = pPageIDs.toArray();
        if (pResultSetSize > pPageIDs.size() / 2) {
            uniqueRandomSet.addAll(pPageIDs);
            while (uniqueRandomSet.size() > pResultSetSize) {
                int randomOffset = rand.nextInt(pPageIDs.size());
                if (!uniqueRandomSet.contains(pageIdArray[randomOffset])) continue;
                uniqueRandomSet.remove(pageIdArray[randomOffset]);
            }
        } else {
            while (uniqueRandomSet.size() < pResultSetSize) {
                int randomOffset = rand.nextInt(pPageIDs.size());
                if (uniqueRandomSet.contains(pageIdArray[randomOffset])) continue;
                uniqueRandomSet.add((Integer)pageIdArray[randomOffset]);
            }
        }
        return uniqueRandomSet;
    }
}

