/*
 * Decompiled with CFR 0.152.
 */
package de.tudarmstadt.ukp.wikipedia.parser.statistics;

import de.tudarmstadt.ukp.wikipedia.api.DatabaseConfiguration;
import de.tudarmstadt.ukp.wikipedia.api.Page;
import de.tudarmstadt.ukp.wikipedia.api.WikiConstants;
import de.tudarmstadt.ukp.wikipedia.api.Wikipedia;
import de.tudarmstadt.ukp.wikipedia.parser.Content;
import de.tudarmstadt.ukp.wikipedia.parser.ParsedPage;
import de.tudarmstadt.ukp.wikipedia.parser.mediawiki.MediaWikiParser;
import de.tudarmstadt.ukp.wikipedia.parser.mediawiki.MediaWikiParserFactory;
import de.tudarmstadt.ukp.wikipedia.parser.mediawiki.ShowTemplateNamesAndParameters;
import java.util.Date;
import java.util.Iterator;

public class Statistics2 {
    static int nrOfPages;
    static int nrOfPagesWithNl;
    static int nrOfPagesWithDl;
    static int nrOfPagesWithBold;
    static int nrOfPagesWithItalic;
    static int nrOfPagesWithMath;
    static int nrOfPagesWithTag;
    static int nrOfPagesWithNoWiki;
    static int nrOfPagesWithTables;
    static int nrOfPagesWithSubSections;
    static int nrOfPagesWithTemplates;
    static int len_longestPage;
    static long len_allPages;
    static int nrOfAnalyzedPages;
    static final int skipPages = 0;
    static final long offsetTime = 0L;
    static final boolean debug = false;
    static final boolean savFiles = false;

    public static void main(String[] argv) throws Exception {
        DatabaseConfiguration dbConfig = new DatabaseConfiguration();
        dbConfig.setDatabase("wikiapi_de");
        dbConfig.setHost("bender.ukp.informatik.tu-darmstadt.de");
        dbConfig.setUser("student");
        dbConfig.setPassword("student");
        dbConfig.setLanguage(WikiConstants.Language.german);
        Wikipedia wiki = new Wikipedia(dbConfig);
        MediaWikiParserFactory pf = new MediaWikiParserFactory();
        pf.setTemplateParserClass(ShowTemplateNamesAndParameters.class);
        pf.setShowImageText(true);
        pf.setShowMathTagContent(true);
        pf.setDeleteTags(false);
        pf.getImageIdentifers().add("IMAGE");
        pf.setCalculateSrcSpans(false);
        MediaWikiParser parser = pf.createParser();
        System.out.println(parser.configurationInfo());
        Iterator<Page> pageIt = wiki.getArticles().iterator();
        nrOfPages = 0;
        nrOfPagesWithNl = 0;
        nrOfPagesWithDl = 0;
        nrOfPagesWithBold = 0;
        nrOfPagesWithItalic = 0;
        nrOfPagesWithMath = 0;
        nrOfPagesWithTag = 0;
        nrOfPagesWithTables = 0;
        nrOfPagesWithSubSections = 0;
        nrOfPagesWithTemplates = 0;
        nrOfPagesWithNoWiki = 0;
        len_allPages = 0L;
        len_longestPage = 0;
        nrOfAnalyzedPages = 0;
        long startTime = new Date().getTime();
        System.out.println("START OF ANALYSATION");
        while (pageIt.hasNext()) {
            Page currentPage = pageIt.next();
            if (++nrOfAnalyzedPages < 1) {
                System.out.println("Skipped: " + currentPage.getPageId());
                continue;
            }
            String name = currentPage.getTitle().getPlainTitle();
            String src = currentPage.getText();
            ParsedPage pp = parser.parse(src);
            if (pp == null) continue;
            pp.setName(name);
            int len_page = src.length();
            if (len_page > len_longestPage) {
                len_longestPage = len_page;
            }
            len_allPages += (long)len_page;
            if (pp.nrOfDefinitionLists() != 0) {
                ++nrOfPagesWithDl;
            }
            if (pp.nrOfNestedLists() != 0) {
                ++nrOfPagesWithNl;
            }
            if (pp.nrOfTables() != 0) {
                ++nrOfPagesWithTables;
            }
            if (pp.getTemplates().size() != 0) {
                ++nrOfPagesWithTemplates;
            }
            if (pp.getSections().size() > 1) {
                ++nrOfPagesWithSubSections;
            }
            for (Content.FormatType ft : pp.getFormats()) {
                if (ft == Content.FormatType.BOLD) {
                    ++nrOfPagesWithBold;
                }
                if (ft == Content.FormatType.ITALIC) {
                    ++nrOfPagesWithItalic;
                }
                if (ft == Content.FormatType.NOWIKI) {
                    ++nrOfPagesWithNoWiki;
                }
                if (ft == Content.FormatType.MATH) {
                    ++nrOfPagesWithMath;
                }
                if (ft != Content.FormatType.TAG) continue;
                ++nrOfPagesWithTag;
            }
            if (nrOfAnalyzedPages % 1024 != 0) continue;
            long aktualTime = new Date().getTime();
            long runnedTime = aktualTime - startTime + 0L;
            long totalTime = runnedTime * (long)nrOfPages / (long)nrOfAnalyzedPages;
            System.out.println(Statistics2.percentString(nrOfAnalyzedPages, nrOfPages) + " -> " + nrOfAnalyzedPages + " of " + nrOfPages + " pages in " + runnedTime / 1000L + "sec" + " -> " + (totalTime - runnedTime) / 60000L + "min left");
            Statistics2.screenInfo();
            System.out.println();
        }
        System.out.println("END OF ANALYSATION");
        Statistics2.screenInfo();
    }

    private static String percentString(long a, long nr) {
        long temp = a * 10000L / nr;
        return temp / 100L + "." + temp / 10L % 10L + "" + temp % 10L + "%";
    }

    private static String pi(String about, int what) {
        return " " + about + ": " + what + " " + Statistics2.percentString(what, nrOfAnalyzedPages) + "\n";
    }

    private static void screenInfo() {
        System.out.print(Statistics2.pi("SUBS", nrOfPagesWithSubSections) + Statistics2.pi("NL", nrOfPagesWithNl) + Statistics2.pi("DL", nrOfPagesWithDl) + Statistics2.pi("TABLES", nrOfPagesWithTables) + Statistics2.pi("TEMPLATES", nrOfPagesWithTemplates) + Statistics2.pi("BOLD", nrOfPagesWithBold) + Statistics2.pi("ITALIC", nrOfPagesWithItalic) + Statistics2.pi("MATH", nrOfPagesWithMath) + Statistics2.pi("TAGS", nrOfPagesWithTag) + Statistics2.pi("NOWIKI", nrOfPagesWithNoWiki));
        System.out.println("longes Page:" + len_longestPage);
        System.out.println("average length:" + len_allPages / (long)nrOfAnalyzedPages);
    }
}

