/*
 * Decompiled with CFR 0.152.
 */
package de.tudarmstadt.ukp.wikipedia.parser.selectiveaccess;

import de.tudarmstadt.ukp.wikipedia.parser.Content;
import de.tudarmstadt.ukp.wikipedia.parser.DefinitionList;
import de.tudarmstadt.ukp.wikipedia.parser.Link;
import de.tudarmstadt.ukp.wikipedia.parser.NestedListContainer;
import de.tudarmstadt.ukp.wikipedia.parser.Paragraph;
import de.tudarmstadt.ukp.wikipedia.parser.ParsedPage;
import de.tudarmstadt.ukp.wikipedia.parser.Section;
import de.tudarmstadt.ukp.wikipedia.parser.SectionContainer;
import de.tudarmstadt.ukp.wikipedia.parser.SectionContent;
import de.tudarmstadt.ukp.wikipedia.parser.Span;
import de.tudarmstadt.ukp.wikipedia.parser.Table;
import de.tudarmstadt.ukp.wikipedia.parser.selectiveaccess.ConfigLoader;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.helpers.DefaultHandler;

public class SelectiveAccessHandler {
    private EnumMap<CIT, Boolean> firstParagraphHandling;
    private EnumMap<CIT, Boolean> pageHandling;
    private Map<String, EnumMap<SIT, EnumMap<CIT, Boolean>>> sectionHandling;
    private int levelModifier = 0;

    public SelectiveAccessHandler() {
        this.loadConfig();
    }

    public SelectiveAccessHandler(String XMLFile) {
        this.loadConfig(XMLFile);
    }

    public static EnumMap<CIT, Boolean> buildCITMap(boolean text, boolean bold, boolean italic, boolean link) {
        EnumMap<CIT, Boolean> result = new EnumMap<CIT, Boolean>(CIT.class);
        result.put(CIT.TEXT, text);
        result.put(CIT.BOLD, bold);
        result.put(CIT.ITALIC, italic);
        result.put(CIT.LINK, link);
        return result;
    }

    public static EnumMap<SIT, EnumMap<CIT, Boolean>> buildSITMap(EnumMap<CIT, Boolean> subs, EnumMap<CIT, Boolean> title, EnumMap<CIT, Boolean> table, EnumMap<CIT, Boolean> deflist, EnumMap<CIT, Boolean> nestedlist, EnumMap<CIT, Boolean> paragraph) {
        EnumMap<SIT, EnumMap<CIT, Boolean>> result = new EnumMap<SIT, EnumMap<CIT, Boolean>>(SIT.class);
        result.put(SIT.SUBS, subs);
        result.put(SIT.TITLE, title);
        result.put(SIT.TABLE, table);
        result.put(SIT.DEFLIST, deflist);
        result.put(SIT.NESTLIST, nestedlist);
        result.put(SIT.PARA, paragraph);
        return result;
    }

    public void setFirstParagraphHandling(EnumMap<CIT, Boolean> firstParagraphHandling) {
        this.firstParagraphHandling = firstParagraphHandling;
    }

    public void setPageHandling(EnumMap<CIT, Boolean> pageHandling) {
        this.pageHandling = pageHandling;
    }

    public Map<String, EnumMap<SIT, EnumMap<CIT, Boolean>>> getSectionHandling() {
        return this.sectionHandling;
    }

    public void setSectionHandling(Map<String, EnumMap<SIT, EnumMap<CIT, Boolean>>> sectionHandling) {
        this.sectionHandling = sectionHandling;
    }

    public void addSectionHandling(int level, EnumMap<SIT, EnumMap<CIT, Boolean>> sh) {
        this.sectionHandling.put(SectionType.SECTION_LEVEL.toString() + level, sh);
    }

    public void addSectionHandling(String name, EnumMap<SIT, EnumMap<CIT, Boolean>> sh) {
        this.sectionHandling.put(SectionType.USER_SECTION.toString() + name.toUpperCase(), sh);
    }

    public void setDefaultSectionHandling(EnumMap<SIT, EnumMap<CIT, Boolean>> sh) {
        this.sectionHandling.put(SectionType.DEFAULT_SECTION.toString(), sh);
    }

    public String getSelectionInfo() {
        StringBuilder result = new StringBuilder();
        result.append("SelectionInfo: " + this.getClass().toString() + "\n");
        result.append("Page:" + SelectiveAccessHandler.CITInfo(this.pageHandling) + "\n");
        result.append("FirstParagraph:" + SelectiveAccessHandler.CITInfo(this.firstParagraphHandling) + "\n");
        for (String key : this.sectionHandling.keySet()) {
            String uss;
            if (key.startsWith(uss = SectionType.USER_SECTION.toString())) {
                result.append(uss + "[" + key.substring(uss.length()) + "]:\n");
            } else {
                result.append(key + ":\n");
            }
            result.append(SelectiveAccessHandler.SITInfo(this.sectionHandling.get(key)) + "\n");
        }
        return result.toString();
    }

    public static String CITInfo(EnumMap<CIT, Boolean> hp) {
        StringBuilder result = new StringBuilder();
        result.append("[");
        if (hp != null) {
            for (CIT key : hp.keySet()) {
                result.append(key.toString() + ":" + hp.get((Object)key) + ", ");
            }
            result.delete(result.length() - 2, result.length());
        }
        result.append("]");
        return result.toString();
    }

    public static String SITInfo(EnumMap<SIT, EnumMap<CIT, Boolean>> shp) {
        StringBuilder result = new StringBuilder();
        for (SIT key : shp.keySet()) {
            result.append("\t" + key.toString() + ":" + SelectiveAccessHandler.CITInfo(shp.get((Object)key)) + "\n");
        }
        return result.toString();
    }

    private void deleteParagraph(int nr, List<Section> sections) {
        int temp = nr;
        for (Section s : sections) {
            nr = temp;
            if ((temp -= s.nrOfParagraphs()) >= 0) continue;
            if (s.getClass() == SectionContainer.class) {
                this.deleteParagraph(nr, ((SectionContainer)s).getSubSections());
                break;
            }
            SectionContent sc = (SectionContent)s;
            sc.removeParagraph(sc.getParagraph(nr));
            break;
        }
    }

    public String getSelectedText(ParsedPage pp) {
        if (pp == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        this.levelModifier = pp.getSection(0).getLevel() - 1;
        if (this.pageHandling == null) {
            if (this.firstParagraphHandling != null) {
                SelectiveAccessHandler.handleContent(pp.getFirstParagraph(), this.firstParagraphHandling, sb);
                this.deleteParagraph(pp.getFirstParagraphNr(), pp.getSections());
            }
            for (Section s : pp.getSections()) {
                this.handleSection(s, sb);
            }
        } else {
            if (this.pageHandling.get((Object)CIT.TEXT).booleanValue()) {
                sb.append(pp.getText());
            } else {
                if (this.pageHandling.get((Object)CIT.BOLD).booleanValue()) {
                    SelectiveAccessHandler.handleSpans(pp.getFormatSpans(Content.FormatType.BOLD), pp.getText(), sb);
                }
                if (this.pageHandling.get((Object)CIT.ITALIC).booleanValue()) {
                    SelectiveAccessHandler.handleSpans(pp.getFormatSpans(Content.FormatType.ITALIC), pp.getText(), sb);
                }
            }
            if (this.pageHandling.get((Object)CIT.LINK).booleanValue()) {
                SelectiveAccessHandler.handleLinks(pp.getLinks(), this.pageHandling.get((Object)CIT.TEXT) == false, sb);
            }
        }
        return sb.toString().trim();
    }

    private static void handleContent(Content c, EnumMap<CIT, Boolean> hp, StringBuilder sb) {
        if (hp != null) {
            if (hp.get((Object)CIT.TEXT).booleanValue()) {
                sb.append(c.getText() + " ");
            } else {
                if (hp.get((Object)CIT.BOLD).booleanValue()) {
                    SelectiveAccessHandler.handleSpans(c.getFormatSpans(Content.FormatType.BOLD), c.getText(), sb);
                }
                if (hp.get((Object)CIT.ITALIC).booleanValue()) {
                    SelectiveAccessHandler.handleSpans(c.getFormatSpans(Content.FormatType.ITALIC), c.getText(), sb);
                }
            }
            if (hp.get((Object)CIT.LINK).booleanValue()) {
                SelectiveAccessHandler.handleLinks(c.getLinks(), hp.get((Object)CIT.TEXT) == false, sb);
            }
        }
    }

    private void handleSection(Section s, StringBuilder sb) {
        block15: {
            EnumMap<SIT, EnumMap<CIT, Boolean>> hp;
            block14: {
                hp = null;
                if (s.getTitle() != null) {
                    hp = this.sectionHandling.get(SectionType.USER_SECTION.toString() + s.getTitle().toUpperCase());
                }
                if (hp == null) {
                    hp = this.sectionHandling.get(SectionType.SECTION_LEVEL.toString() + (s.getLevel() - this.levelModifier));
                }
                if (hp == null) {
                    hp = this.sectionHandling.get(SectionType.DEFAULT_SECTION.toString());
                }
                if (hp == null) {
                    System.err.println("Cannot get Handling Parameters for Section:\"" + s.getTitle() + "\" Level:" + s.getLevel());
                    return;
                }
                SelectiveAccessHandler.handleContent(s.getTitleElement(), hp.get((Object)SIT.TITLE), sb);
                if (s.getClass() != SectionContainer.class) break block14;
                if (hp.get((Object)SIT.SUBS) != null) {
                    SelectiveAccessHandler.handleContent(s, hp.get((Object)SIT.SUBS), sb);
                } else {
                    for (Section ss : ((SectionContainer)s).getSubSections()) {
                        this.handleSection(ss, sb);
                    }
                }
                break block15;
            }
            EnumMap<CIT, Boolean> hpx = hp.get((Object)SIT.TABLE);
            if (hpx != null) {
                for (Table t : s.getTables()) {
                    SelectiveAccessHandler.handleContent(t, hpx, sb);
                }
            }
            if ((hpx = hp.get((Object)SIT.NESTLIST)) != null) {
                for (NestedListContainer nl : s.getNestedLists()) {
                    SelectiveAccessHandler.handleContent(nl, hpx, sb);
                }
            }
            if ((hpx = hp.get((Object)SIT.PARA)) != null) {
                for (Paragraph p : s.getParagraphs()) {
                    SelectiveAccessHandler.handleContent(p, hpx, sb);
                }
            }
            if ((hpx = hp.get((Object)SIT.DEFLIST)) == null) break block15;
            for (DefinitionList dl : s.getDefinitionLists()) {
                SelectiveAccessHandler.handleContent(dl, hpx, sb);
            }
        }
    }

    private static void handleSpans(List<Span> spans, String text, StringBuilder sb) {
        for (Span s : spans) {
            sb.append(text.substring(s.getStart(), s.getEnd()) + " ");
        }
    }

    private static void handleLinks(List<Link> links, boolean linktext, StringBuilder sb) {
        for (Link l : links) {
            switch (l.getType()) {
                case INTERNAL: {
                    String lText = l.getText();
                    String lTarget = l.getTarget();
                    if (linktext) {
                        sb.append(lText + " ");
                    }
                    if (lText.equals(lTarget)) break;
                    sb.append(lTarget + " ");
                    break;
                }
                case EXTERNAL: {
                    sb.append(l.getText() + " ");
                    break;
                }
            }
        }
    }

    private void loadConfig() {
        this.firstParagraphHandling = null;
        this.pageHandling = null;
        this.sectionHandling = new HashMap<String, EnumMap<SIT, EnumMap<CIT, Boolean>>>();
        this.setDefaultSectionHandling(SelectiveAccessHandler.buildSITMap(SelectiveAccessHandler.buildCITMap(false, false, false, false), null, null, null, null, null));
    }

    public void loadConfig(String XMLFile) {
        try {
            this.sectionHandling = new HashMap<String, EnumMap<SIT, EnumMap<CIT, Boolean>>>();
            SAXParserFactory factory = SAXParserFactory.newInstance();
            factory.setNamespaceAware(true);
            SAXParser sp = factory.newSAXParser();
            ConfigLoader handler = new ConfigLoader(this);
            sp.parse(XMLFile, (DefaultHandler)handler);
        }
        catch (Exception e) {
            System.err.println(e);
            this.loadConfig();
        }
    }

    private static String XMLCIT(EnumMap<CIT, Boolean> em) {
        StringBuilder result = new StringBuilder();
        result.append("<cit");
        if (em != null) {
            for (CIT key : em.keySet()) {
                result.append(" " + key.toString() + "=\"" + em.get((Object)key) + "\"");
            }
        }
        result.append("/>");
        return result.toString();
    }

    private static String XMLSIT(EnumMap<SIT, EnumMap<CIT, Boolean>> sem) {
        StringBuilder result = new StringBuilder();
        for (SIT key : sem.keySet()) {
            result.append("<" + key.toString() + ">");
            result.append(SelectiveAccessHandler.XMLCIT(sem.get((Object)key)));
            result.append("</" + key.toString() + ">\n");
        }
        return result.toString();
    }

    public void writeConfig(String XMLFile) {
        try {
            BufferedWriter bw = new BufferedWriter(new FileWriter(XMLFile));
            bw.write("<SelectiveAccessHandlerConfig>\n");
            bw.write("<page>" + SelectiveAccessHandler.XMLCIT(this.pageHandling) + "</page>\n");
            bw.write("<firstparagraph>" + SelectiveAccessHandler.XMLCIT(this.pageHandling) + "</firstparagraph>\n");
            for (String key : this.sectionHandling.keySet()) {
                bw.write("<section name=\"" + key + "\">\n");
                bw.write(SelectiveAccessHandler.XMLSIT(this.sectionHandling.get(key)));
                bw.write("</section>\n");
            }
            bw.write("<SelectiveAccessHandlerConfig>\n");
            bw.close();
        }
        catch (IOException e) {
            System.err.println(e);
        }
    }

    protected static enum SectionType {
        DEFAULT_SECTION,
        SECTION_LEVEL,
        USER_SECTION;

    }

    static enum SIT {
        SUBS,
        TITLE,
        TABLE,
        DEFLIST,
        NESTLIST,
        PARA;

    }

    static enum CIT {
        TEXT,
        BOLD,
        ITALIC,
        LINK;

    }
}

