/*
 * Decompiled with CFR 0.152.
 */
package de.tudarmstadt.ukp.wikipedia.parser.selectiveaccess;

import de.tudarmstadt.ukp.wikipedia.parser.selectiveaccess.SelectiveAccessHandler;
import java.util.EnumMap;
import java.util.Map;
import org.xml.sax.Attributes;
import org.xml.sax.helpers.DefaultHandler;

class ConfigLoader
extends DefaultHandler {
    SelectiveAccessHandler sah;
    private EnumMap<SelectiveAccessHandler.CIT, Boolean> citm;
    private EnumMap<SelectiveAccessHandler.SIT, EnumMap<SelectiveAccessHandler.CIT, Boolean>> sitm;
    private Attributes secatt;
    private Map<String, EnumMap<SelectiveAccessHandler.SIT, EnumMap<SelectiveAccessHandler.CIT, Boolean>>> sectionHandling;

    public ConfigLoader(SelectiveAccessHandler sah) {
        this.sah = sah;
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes att) {
        if (localName.equalsIgnoreCase("cit")) {
            this.citm = SelectiveAccessHandler.buildCITMap("true".equalsIgnoreCase(att.getValue("text")), "true".equalsIgnoreCase(att.getValue("bold")), "true".equalsIgnoreCase(att.getValue("italic")), "true".equalsIgnoreCase(att.getValue("link")));
        } else if (localName.equalsIgnoreCase("section")) {
            this.sitm = new EnumMap(SelectiveAccessHandler.SIT.class);
            this.secatt = att;
        } else if (localName.equalsIgnoreCase(SelectiveAccessHandler.SIT.SUBS.toString())) {
            this.citm = null;
        } else if (localName.equalsIgnoreCase(SelectiveAccessHandler.SIT.TITLE.toString())) {
            this.citm = null;
        } else if (localName.equalsIgnoreCase(SelectiveAccessHandler.SIT.DEFLIST.toString())) {
            this.citm = null;
        } else if (localName.equalsIgnoreCase(SelectiveAccessHandler.SIT.TABLE.toString())) {
            this.citm = null;
        } else if (localName.equalsIgnoreCase(SelectiveAccessHandler.SIT.NESTLIST.toString())) {
            this.citm = null;
        } else if (localName.equalsIgnoreCase(SelectiveAccessHandler.SIT.PARA.toString())) {
            this.citm = null;
        } else if (localName.equalsIgnoreCase("page")) {
            this.citm = null;
        } else if (localName.equalsIgnoreCase("firstParagraph")) {
            this.citm = null;
        } else if (localName.equalsIgnoreCase("SelectiveAccessHandlerConfig")) {
            this.sah.setPageHandling(null);
            this.sah.setFirstParagraphHandling(null);
            this.sectionHandling = this.sah.getSectionHandling();
            this.sectionHandling.clear();
        } else {
            System.err.println("UnhandledElement: " + localName);
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) {
        if (!localName.equalsIgnoreCase("cit")) {
            if (localName.equalsIgnoreCase("section")) {
                String name = this.secatt.getValue("name");
                if (name != null) {
                    if (name.startsWith(SelectiveAccessHandler.SectionType.DEFAULT_SECTION.toString()) || name.startsWith(SelectiveAccessHandler.SectionType.SECTION_LEVEL.toString()) || name.startsWith(SelectiveAccessHandler.SectionType.USER_SECTION.toString())) {
                        this.sectionHandling.put(name, this.sitm);
                    } else {
                        this.sectionHandling.put(SelectiveAccessHandler.SectionType.USER_SECTION.toString() + name, this.sitm);
                    }
                } else {
                    this.sah.setDefaultSectionHandling(this.sitm);
                }
            } else if (localName.equalsIgnoreCase(SelectiveAccessHandler.SIT.SUBS.toString())) {
                this.sitm.put(SelectiveAccessHandler.SIT.SUBS, this.citm);
            } else if (localName.equalsIgnoreCase(SelectiveAccessHandler.SIT.TITLE.toString())) {
                this.sitm.put(SelectiveAccessHandler.SIT.TITLE, this.citm);
            } else if (localName.equalsIgnoreCase(SelectiveAccessHandler.SIT.TABLE.toString())) {
                this.sitm.put(SelectiveAccessHandler.SIT.TABLE, this.citm);
            } else if (localName.equalsIgnoreCase(SelectiveAccessHandler.SIT.DEFLIST.toString())) {
                this.sitm.put(SelectiveAccessHandler.SIT.DEFLIST, this.citm);
            } else if (localName.equalsIgnoreCase(SelectiveAccessHandler.SIT.NESTLIST.toString())) {
                this.sitm.put(SelectiveAccessHandler.SIT.NESTLIST, this.citm);
            } else if (localName.equalsIgnoreCase(SelectiveAccessHandler.SIT.PARA.toString())) {
                this.sitm.put(SelectiveAccessHandler.SIT.PARA, this.citm);
            } else if (localName.equalsIgnoreCase("page")) {
                this.sah.setPageHandling(this.citm);
            } else if (localName.equalsIgnoreCase("firstParagraph")) {
                this.sah.setFirstParagraphHandling(this.citm);
            } else if (!localName.equalsIgnoreCase("SelectiveAccessHandlerConfig")) {
                System.err.println("UnhandledElement: " + localName);
            }
        }
    }
}

