/*
 * Decompiled with CFR 0.152.
 */
package de.tudarmstadt.ukp.wikipedia.parser.mediawiki;

import de.tudarmstadt.ukp.wikipedia.parser.Content;
import de.tudarmstadt.ukp.wikipedia.parser.ContentElement;
import de.tudarmstadt.ukp.wikipedia.parser.DefinitionList;
import de.tudarmstadt.ukp.wikipedia.parser.Link;
import de.tudarmstadt.ukp.wikipedia.parser.NestedList;
import de.tudarmstadt.ukp.wikipedia.parser.NestedListContainer;
import de.tudarmstadt.ukp.wikipedia.parser.Paragraph;
import de.tudarmstadt.ukp.wikipedia.parser.ParsedPage;
import de.tudarmstadt.ukp.wikipedia.parser.Section;
import de.tudarmstadt.ukp.wikipedia.parser.SectionContainer;
import de.tudarmstadt.ukp.wikipedia.parser.SectionContent;
import de.tudarmstadt.ukp.wikipedia.parser.Span;
import de.tudarmstadt.ukp.wikipedia.parser.SrcSpan;
import de.tudarmstadt.ukp.wikipedia.parser.Table;
import de.tudarmstadt.ukp.wikipedia.parser.TableElement;
import de.tudarmstadt.ukp.wikipedia.parser.Template;
import java.util.ArrayList;
import java.util.List;

public class SrcPosRangeChecker {
    public static void checkRange(ParsedPage pp) {
        for (Section s : pp.getSections()) {
            if (s.getClass() == SectionContent.class) {
                SrcPosRangeChecker.checkRange((SectionContent)s);
                continue;
            }
            SrcPosRangeChecker.checkRange((SectionContainer)s);
        }
    }

    private static void checkRange(SectionContainer sc) {
        if (sc.getTitleElement() != null) {
            SrcPosRangeChecker.checkRange(sc.getTitleElement());
        }
        for (Section s : sc.getSubSections()) {
            if (s.getClass() == SectionContent.class) {
                SrcPosRangeChecker.checkRange((SectionContent)s);
                continue;
            }
            SrcPosRangeChecker.checkRange((SectionContainer)s);
        }
    }

    private static void checkRange(SectionContent s) {
        ArrayList<SrcSpan> eil = new ArrayList<SrcSpan>();
        if (s.getTitleElement() != null) {
            SrcPosRangeChecker.checkRange(s.getTitleElement());
            eil.add(s.getTitleElement().getSrcSpan());
        }
        for (Paragraph p : s.getParagraphs()) {
            SrcPosRangeChecker.checkRange(p);
            eil.add(p.getSrcSpan());
        }
        for (DefinitionList dl : s.getDefinitionLists()) {
            SrcPosRangeChecker.checkRange(dl);
            eil.add(dl.getSrcSpan());
        }
        for (NestedListContainer nl : s.getNestedLists()) {
            SrcPosRangeChecker.checkRange(nl);
            eil.add(nl.getSrcSpan());
        }
        for (Table t : s.getTables()) {
            SrcPosRangeChecker.checkRange(t);
            eil.add(t.getSrcSpan());
        }
        s.setSrcSpan(SrcPosRangeChecker.getEvalInfo(s.getSrcSpan(), eil));
    }

    private static void checkRange(DefinitionList dl) {
    }

    private static void checkRange(NestedListContainer nlc) {
        for (NestedList nl : nlc.getNestedLists()) {
            if (nl.getClass() == NestedListContainer.class) {
                SrcPosRangeChecker.checkRange((NestedListContainer)nl);
                continue;
            }
            SrcPosRangeChecker.checkRange((ContentElement)((Object)nl));
        }
    }

    private static void checkRange(Table t) {
        ArrayList<SrcSpan> eil = new ArrayList<SrcSpan>();
        for (int i = 0; i < t.nrOfTableElements(); ++i) {
            TableElement te = t.getTableElement(i);
            SrcPosRangeChecker.checkRange(te);
            eil.add(te.getSrcSpan());
        }
        t.setSrcSpan(SrcPosRangeChecker.getEvalInfo(t.getSrcSpan(), eil));
    }

    private static void checkRange(TableElement te) {
        ArrayList<SrcSpan> eil = new ArrayList<SrcSpan>();
        for (Section s : te.getSubSections()) {
            if (s.getClass() == SectionContent.class) {
                SrcPosRangeChecker.checkRange((SectionContent)s);
                continue;
            }
            SrcPosRangeChecker.checkRange((SectionContainer)s);
        }
        te.setSrcSpan(SrcPosRangeChecker.getEvalInfo(te.getSrcSpan(), eil));
    }

    private static void checkRange(ContentElement ce) {
        ArrayList<SrcSpan> eil = new ArrayList<SrcSpan>();
        for (Span s : ce.getFormatSpans(Content.FormatType.BOLD)) {
            eil.add(s.getSrcSpan());
        }
        for (Span s : ce.getFormatSpans(Content.FormatType.ITALIC)) {
            eil.add(s.getSrcSpan());
        }
        for (Span s : ce.getFormatSpans(Content.FormatType.MATH)) {
            eil.add(s.getSrcSpan());
        }
        for (Span s : ce.getFormatSpans(Content.FormatType.TAG)) {
            eil.add(s.getSrcSpan());
        }
        for (Span s : ce.getFormatSpans(Content.FormatType.NOWIKI)) {
            eil.add(s.getSrcSpan());
        }
        for (Link l : ce.getLinks()) {
            eil.add(l.getSrcSpan());
        }
        for (Template t : ce.getTemplates()) {
            eil.add(t.getSrcSpan());
        }
        ce.setSrcSpan(SrcPosRangeChecker.getEvalInfo(ce.getSrcSpan(), eil));
    }

    private static SrcSpan getEvalInfo(SrcSpan e, List<SrcSpan> eil) {
        int start = e.getStart();
        int end = e.getEnd();
        for (SrcSpan ei : eil) {
            if (start == -1 || start > ei.getStart() && ei.getStart() != -1) {
                start = ei.getStart();
            }
            if (end >= ei.getEnd()) continue;
            end = ei.getEnd();
        }
        return new SrcSpan(start, end);
    }
}

