/*
 * Decompiled with CFR 0.152.
 */
package de.tudarmstadt.ukp.wikipedia.parser.mediawiki;

import de.tudarmstadt.ukp.wikipedia.parser.ParsedPage;
import de.tudarmstadt.ukp.wikipedia.parser.Template;
import de.tudarmstadt.ukp.wikipedia.parser.mediawiki.MediaWikiTemplateParser;
import de.tudarmstadt.ukp.wikipedia.parser.mediawiki.ResolvedTemplate;

public class ShowTemplateNamesAndParameters
implements MediaWikiTemplateParser {
    private final String templatePrefix = "TEMPLATE[";
    private final String templatePostfix = "]";
    private final String parameterDivisor = ", ";

    @Override
    public ResolvedTemplate parseTemplate(Template t, ParsedPage pp) {
        ResolvedTemplate result = new ResolvedTemplate(t);
        result.setPreParseReplacement("(TEMPLATE)");
        StringBuilder sb = new StringBuilder();
        sb.append("TEMPLATE[");
        sb.append(t.getName() + ", ");
        for (String s : t.getParameters()) {
            sb.append(s + ", ");
        }
        sb.delete(sb.length() - ", ".length(), sb.length());
        sb.append("]");
        result.setPostParseReplacement(sb.toString());
        result.setParsedObject(t);
        return result;
    }

    @Override
    public String configurationInfo() {
        return "shows the Template names and all parameters";
    }
}

