/*
 * Decompiled with CFR 0.152.
 */
package de.tudarmstadt.ukp.wikipedia.parser.mediawiki;

import de.tudarmstadt.ukp.wikipedia.parser.ContentElement;
import de.tudarmstadt.ukp.wikipedia.parser.DefinitionList;
import de.tudarmstadt.ukp.wikipedia.parser.NestedList;
import de.tudarmstadt.ukp.wikipedia.parser.NestedListContainer;
import de.tudarmstadt.ukp.wikipedia.parser.Paragraph;
import de.tudarmstadt.ukp.wikipedia.parser.Section;
import de.tudarmstadt.ukp.wikipedia.parser.SectionContainer;
import de.tudarmstadt.ukp.wikipedia.parser.SectionContent;
import de.tudarmstadt.ukp.wikipedia.parser.Table;
import de.tudarmstadt.ukp.wikipedia.parser.TableElement;

class EmptyStructureRemover {
    EmptyStructureRemover() {
    }

    public static SectionContainer eliminateEmptyStructures(SectionContainer sc) {
        SectionContainer sc0;
        for (int i = sc.nrOfSubSections() - 1; i >= 0; --i) {
            Section ss = sc.getSubSection(i);
            if (ss.getClass() == SectionContainer.class) {
                SectionContainer sci = (SectionContainer)ss;
                EmptyStructureRemover.eliminateEmptyStructures(sci);
            } else if (ss.getClass() == SectionContent.class) {
                EmptyStructureRemover.eliminateEmptyStructures((SectionContent)ss);
            }
            if (!ss.empty()) continue;
            sc.removeSection(ss);
        }
        if (sc.nrOfSubSections() == 1 && sc.getSubSection(0).getClass() == SectionContainer.class && (sc0 = (SectionContainer)sc.getSubSection(0)).getTitleElement() == null) {
            sc.removeSection(sc0);
            for (int i = 0; i < sc0.nrOfSubSections(); ++i) {
                sc.addSection(sc0.getSubSection(i));
            }
        }
        return sc;
    }

    public static SectionContent eliminateEmptyStructures(SectionContent sc) {
        int i;
        for (i = sc.nrOfParagraphs() - 1; i >= 0; --i) {
            Paragraph p = sc.getParagraph(i);
            if (!p.empty()) continue;
            sc.removeParagraph(p);
        }
        for (i = sc.nrOfDefinitionLists() - 1; i >= 0; --i) {
            DefinitionList dl = sc.getDefinitionList(i);
            EmptyStructureRemover.eliminateEmptyStructures(dl);
            if (!dl.empty()) continue;
            sc.removeDefinitionList(dl);
        }
        for (i = sc.nrOfNestedLists() - 1; i >= 0; --i) {
            NestedListContainer nl = sc.getNestedList(i);
            EmptyStructureRemover.eliminateEmptyStructures(nl);
            if (!nl.empty()) continue;
            sc.removeNestedList(nl);
        }
        for (i = sc.nrOfTables() - 1; i >= 0; --i) {
            Table t = sc.getTable(i);
            EmptyStructureRemover.eliminateEmptyStructures(t);
            if (!t.empty()) continue;
            sc.removeTable(t);
        }
        return sc;
    }

    public static NestedListContainer eliminateEmptyStructures(NestedListContainer nlc) {
        for (int i = nlc.size() - 1; i >= 0; --i) {
            NestedList nl = nlc.getNestedList(i);
            if (nl.getClass() == NestedListContainer.class) {
                EmptyStructureRemover.eliminateEmptyStructures((NestedListContainer)nl);
            }
            if (!nl.empty()) continue;
            nlc.remove(nl);
        }
        return nlc;
    }

    public static Table eliminateEmptyStructures(Table t) {
        for (int i = t.nrOfTableElements() - 1; i >= 0; --i) {
            TableElement te = t.getTableElement(i);
            EmptyStructureRemover.eliminateEmptyStructures(te);
            if (!te.empty()) continue;
            t.removeTableElement(te);
        }
        return t;
    }

    public static TableElement eliminateEmptyStructures(TableElement te) {
        for (int i = te.nrOfSections() - 1; i >= 0; --i) {
            Section s = te.getSection(i);
            if (s.getClass() == SectionContainer.class) {
                EmptyStructureRemover.eliminateEmptyStructures((SectionContainer)s);
            } else if (s.getClass() == SectionContent.class) {
                EmptyStructureRemover.eliminateEmptyStructures((SectionContent)s);
            }
            if (!s.empty()) continue;
            te.removeSection(s);
        }
        return te;
    }

    public static DefinitionList eliminateEmptyStructures(DefinitionList dl) {
        ContentElement dt = dl.getDefinedTerm();
        if (dt != null && dt.empty()) {
            dl.setDefinedTerm(null);
        }
        for (int i = dl.nrOfDefinitions() - 1; i >= 0; --i) {
            ContentElement ce = dl.getDefinition(i);
            if (!ce.empty()) continue;
            dl.removeDefinition(ce);
        }
        return dl;
    }
}

