/*
 * Decompiled with CFR 0.152.
 */
package de.tudarmstadt.ukp.wikipedia.parser;

import de.tudarmstadt.ukp.wikipedia.parser.ParsedPageObject;

public class Span
extends ParsedPageObject {
    private int start;
    private int end;
    public static final char ERRORCHAR = '\u0000';

    public Span(int start, int end) {
        this.start = start;
        this.end = end;
    }

    public int getStart() {
        return this.start;
    }

    public Span setStart(int start) {
        this.start = start;
        return this;
    }

    public Span adjustStart(int n) {
        this.start += n;
        return this;
    }

    public int getEnd() {
        return this.end;
    }

    public Span setEnd(int end) {
        this.end = end;
        return this;
    }

    public Span adjustEnd(int n) {
        this.end += n;
        return this;
    }

    public Span adjust(int n) {
        return this.adjust(0, n);
    }

    public Span adjust(int offset, int n) {
        if (offset < 0) {
            return this;
        }
        if (offset < this.end) {
            this.end += n;
            if (this.end < offset) {
                this.end = offset;
            }
        } else {
            return this;
        }
        if (offset < this.start) {
            this.start += n;
            if (this.start < offset) {
                this.start = offset;
            }
        }
        return this;
    }

    public boolean equals(int start, int end) {
        return this.start == start && this.end == end;
    }

    public boolean equals(Span s) {
        return this.start == s.getStart() && this.end == s.getEnd();
    }

    public boolean hits(Span s) {
        return this.start < s.getEnd() && s.getStart() < this.end;
    }

    public String toString() {
        return "(" + this.start + ", " + this.end + ")";
    }

    public String getText(String src) {
        if (this.end > src.length()) {
            this.end = src.length();
        }
        return src.substring(this.start, this.end);
    }

    public char charAt(int pos, CharSequence cs) {
        if (pos + this.start < this.end) {
            return cs.charAt(this.start + pos);
        }
        return '\u0000';
    }

    public int nonWSCharPos(CharSequence cs) {
        int pos = 0;
        while (this.charAt(pos, cs) == ' ') {
            ++pos;
        }
        return pos;
    }

    public Span trimTrail(CharSequence src) {
        if (this.start < this.end) {
            while (src.charAt(this.end - 1) == ' ') {
                --this.end;
                if (this.start != this.end) continue;
                break;
            }
        }
        return this;
    }

    public Span trim(CharSequence src) {
        if (this.start < this.end) {
            while (src.charAt(this.end - 1) == ' ') {
                --this.end;
                if (this.start != this.end) continue;
            }
        }
        if (this.start < this.end) {
            while (src.charAt(this.start) == ' ') {
                ++this.start;
                if (this.start != this.end) continue;
                break;
            }
        }
        return this;
    }

    public int length() {
        return this.end - this.start;
    }

    public Span clone() {
        Span result = new Span(this.start, this.end);
        result.setSrcSpan(this.getSrcSpan());
        return result;
    }
}

