/*
 * Decompiled with CFR 0.152.
 */
package de.tudarmstadt.ukp.wikipedia.parser;

import de.tudarmstadt.ukp.wikipedia.parser.Content;
import de.tudarmstadt.ukp.wikipedia.parser.ContentElement;
import de.tudarmstadt.ukp.wikipedia.parser.DefinitionList;
import de.tudarmstadt.ukp.wikipedia.parser.NestedListContainer;
import de.tudarmstadt.ukp.wikipedia.parser.Paragraph;
import de.tudarmstadt.ukp.wikipedia.parser.Section;
import de.tudarmstadt.ukp.wikipedia.parser.Table;
import java.util.ArrayList;
import java.util.List;

public class SectionContainer
extends Section {
    private List<Section> sections = new ArrayList<Section>();

    public SectionContainer(int level) {
        super(null, level);
    }

    public SectionContainer(ContentElement title, int level) {
        super(title, level);
    }

    public int nrOfSubSections() {
        return this.sections.size();
    }

    public void addSection(Section s) {
        this.sections.add(s);
        this.ccl.add(s);
    }

    public void removeSection(Section s) {
        this.sections.remove(s);
        this.ccl.remove(s);
    }

    public Section getSubSection(int i) {
        if (this.sections.size() > i) {
            return this.sections.get(i);
        }
        return null;
    }

    public List<Section> getSubSections() {
        return new ArrayList<Section>(this.sections);
    }

    @Override
    public List<Content> getContentList() {
        return new ArrayList<Content>(this.ccl);
    }

    @Override
    public int nrOfParagraphs() {
        int result = 0;
        for (Section s : this.sections) {
            result += s.nrOfParagraphs();
        }
        return result;
    }

    @Override
    public Paragraph getParagraph(int i) {
        int nr = 0;
        int offset = 0;
        for (Section s : this.sections) {
            nr = s.nrOfParagraphs();
            if (nr + offset > i) {
                return s.getParagraph(i - offset);
            }
            offset += nr;
        }
        return null;
    }

    @Override
    public List<Paragraph> getParagraphs() {
        ArrayList<Paragraph> result = new ArrayList<Paragraph>();
        for (Section s : this.sections) {
            result.addAll(s.getParagraphs());
        }
        return result;
    }

    @Override
    public int nrOfTables() {
        int result = 0;
        for (Section s : this.sections) {
            result += s.nrOfTables();
        }
        return result;
    }

    @Override
    public Table getTable(int i) {
        int nr = 0;
        int offset = 0;
        for (Section s : this.sections) {
            nr = s.nrOfTables();
            if (nr + offset > i) {
                return s.getTable(i - offset);
            }
            offset += nr;
        }
        return null;
    }

    @Override
    public List<Table> getTables() {
        ArrayList<Table> result = new ArrayList<Table>();
        for (Section s : this.sections) {
            result.addAll(s.getTables());
        }
        return result;
    }

    @Override
    public int nrOfNestedLists() {
        int result = 0;
        for (Section s : this.sections) {
            result += s.nrOfNestedLists();
        }
        return result;
    }

    @Override
    public NestedListContainer getNestedList(int i) {
        int nr = 0;
        int offset = 0;
        for (Section s : this.sections) {
            nr = s.nrOfNestedLists();
            if (nr + offset > i) {
                return s.getNestedList(i - offset);
            }
            offset += nr;
        }
        return null;
    }

    @Override
    public List<NestedListContainer> getNestedLists() {
        ArrayList<NestedListContainer> result = new ArrayList<NestedListContainer>();
        for (Section s : this.sections) {
            result.addAll(s.getNestedLists());
        }
        return result;
    }

    @Override
    public int nrOfDefinitionLists() {
        int result = 0;
        for (Section s : this.sections) {
            result += s.nrOfDefinitionLists();
        }
        return result;
    }

    @Override
    public DefinitionList getDefinitionList(int i) {
        int nr = 0;
        int offset = 0;
        for (Section s : this.sections) {
            nr = s.nrOfDefinitionLists();
            if (nr + offset > i) {
                return s.getDefinitionList(i - offset);
            }
            offset += nr;
        }
        return null;
    }

    @Override
    public List<DefinitionList> getDefinitionLists() {
        ArrayList<DefinitionList> result = new ArrayList<DefinitionList>();
        for (Section s : this.sections) {
            result.addAll(s.getDefinitionLists());
        }
        return result;
    }

    @Override
    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append("SS_TITLE:\n" + this.getTitleElement());
        result.append("\nSS_LEVEL: " + this.getLevel());
        result.append("\nSS_SUBSECTIONS: " + this.sections.size());
        for (Section s : this.sections) {
            result.append("\nSS_SUBSECTION:\n" + s.toString());
        }
        return result.toString();
    }
}

