/*
 * Decompiled with CFR 0.152.
 */
package de.tudarmstadt.ukp.wikipedia.parser;

import de.tudarmstadt.ukp.wikipedia.parser.Content;
import de.tudarmstadt.ukp.wikipedia.parser.ParsedPageObject;
import de.tudarmstadt.ukp.wikipedia.parser.Span;
import java.util.ArrayList;
import java.util.List;

public class Link
extends ParsedPageObject {
    private Content home_cc;
    private final type t;
    private final Span pos;
    private final String target;
    private final List<String> parameters;

    public Link(Content home_cc, Span linkPos, String target, type t, List<String> parameters) {
        this.home_cc = home_cc;
        this.pos = linkPos;
        this.target = target;
        this.t = t;
        this.parameters = parameters == null ? new ArrayList() : parameters;
    }

    public Content getHomeElement() {
        return this.home_cc;
    }

    public Link setHomeElement(Content home_cc) {
        this.home_cc = home_cc;
        return this;
    }

    public type getType() {
        return this.t;
    }

    public Span getPos() {
        return this.pos;
    }

    public String getTarget() {
        return this.target;
    }

    public List<String> getParameters() {
        return this.parameters;
    }

    public String getText() {
        if (this.home_cc == null) {
            return null;
        }
        return this.pos.getText(this.home_cc.getText());
    }

    public String getContext(int wordsLeft, int wordsRight) {
        int posRight;
        String text = this.home_cc.getText();
        int posLeft = this.pos.getStart();
        int temp = posLeft - 1;
        while (posLeft != 0 && wordsLeft > 0) {
            while (temp > 0 && text.charAt(temp) < '0') {
                --temp;
            }
            while (temp > 0 && text.charAt(temp) >= '0') {
                --temp;
            }
            posLeft = temp > 0 ? temp + 1 : 0;
            --wordsLeft;
        }
        temp = posRight = this.pos.getEnd();
        while (posRight != text.length() && wordsRight > 0) {
            while (temp < text.length() && text.charAt(temp) < '0') {
                ++temp;
            }
            while (temp < text.length() && text.charAt(temp) >= '0') {
                ++temp;
            }
            posRight = temp;
            --wordsRight;
        }
        return text.substring(posLeft, this.pos.getStart()) + text.substring(this.pos.getEnd(), posRight);
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append("LI_TYPE: " + (Object)((Object)this.t));
        result.append("\nLI_TARGET: \"" + this.target + "\"");
        result.append("\nLI_TEXT: \"" + this.getText() + "\"");
        result.append("\nLI_POSITION: \"" + this.pos + "\"");
        result.append("\nLI_PARAMETERS: " + this.parameters.size());
        for (String s : this.parameters) {
            result.append("\nLI_PARAMETER: \"" + s + "\"");
        }
        return result.toString();
    }

    public static enum type {
        EXTERNAL,
        INTERNAL,
        AUDIO,
        VIDEO,
        IMAGE,
        UNKNOWN;

    }
}

