/*
 * Decompiled with CFR 0.152.
 */
package de.tudarmstadt.ukp.wikipedia.api.tutorial;

import de.tudarmstadt.ukp.wikipedia.api.Category;
import de.tudarmstadt.ukp.wikipedia.api.DatabaseConfiguration;
import de.tudarmstadt.ukp.wikipedia.api.Page;
import de.tudarmstadt.ukp.wikipedia.api.WikiConstants;
import de.tudarmstadt.ukp.wikipedia.api.Wikipedia;
import de.tudarmstadt.ukp.wikipedia.api.exception.WikiApiException;
import de.tudarmstadt.ukp.wikipedia.api.exception.WikiPageNotFoundException;
import java.util.TreeSet;

public class T5_TownList
implements WikiConstants {
    public static void main(String[] args) throws WikiApiException {
        Category topCat;
        DatabaseConfiguration dbConfig = new DatabaseConfiguration();
        dbConfig.setHost("SERVER_URL");
        dbConfig.setDatabase("DATABASE");
        dbConfig.setUser("USER");
        dbConfig.setPassword("PASSWORD");
        dbConfig.setLanguage(WikiConstants.Language.german);
        Wikipedia wiki = new Wikipedia(dbConfig);
        String title = "Towns in Germany";
        try {
            topCat = wiki.getCategory(title);
        }
        catch (WikiPageNotFoundException e) {
            throw new WikiApiException("Category " + title + " does not exist");
        }
        TreeSet<String> towns = new TreeSet<String>();
        for (Page p : topCat.getArticles()) {
            towns.add(p.getTitle().getPlainTitle());
        }
        for (Category townCategory : topCat.getDescendants()) {
            for (Page p : townCategory.getArticles()) {
                towns.add(p.getTitle().getPlainTitle());
            }
            System.out.println("Number of towns: " + towns.size());
        }
        for (String town : towns) {
            System.out.println(town);
        }
    }
}

