/*
 * Decompiled with CFR 0.152.
 */
package de.tudarmstadt.ukp.wikipedia.api.hibernate;

import de.tudarmstadt.ukp.wikipedia.api.DatabaseConfiguration;
import de.tudarmstadt.ukp.wikipedia.api.WikiConstants;
import de.tudarmstadt.ukp.wikipedia.api.hibernate.Category;
import de.tudarmstadt.ukp.wikipedia.api.hibernate.MetaData;
import de.tudarmstadt.ukp.wikipedia.api.hibernate.Page;
import de.tudarmstadt.ukp.wikipedia.api.hibernate.PageMapLine;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.hibernate.SessionFactory;
import org.hibernate.cfg.Configuration;

public class WikiHibernateUtil
implements WikiConstants {
    private static Map<String, SessionFactory> sessionFactoryMap = new HashMap<String, SessionFactory>();

    public static SessionFactory getSessionFactory(DatabaseConfiguration config) {
        if (config.getLanguage() == null) {
            throw new ExceptionInInitializerError("Database configuration error. 'Language' is empty.");
        }
        if (config.getHost() == null) {
            throw new ExceptionInInitializerError("Database configuration error. 'Host' is empty.");
        }
        if (config.getDatabase() == null) {
            throw new ExceptionInInitializerError("Database configuration error. 'Database' is empty.");
        }
        String uniqueSessionKey = config.getLanguage().toString() + config.getHost() + config.getDatabase();
        if (!sessionFactoryMap.containsKey(uniqueSessionKey)) {
            SessionFactory sessionFactory = WikiHibernateUtil.getConfiguration(config).buildSessionFactory();
            sessionFactoryMap.put(uniqueSessionKey, sessionFactory);
        }
        return sessionFactoryMap.get(uniqueSessionKey);
    }

    private static Properties getProperties(DatabaseConfiguration config) {
        String host = config.getHost();
        String db = config.getDatabase();
        String user = config.getUser();
        String password = config.getPassword();
        Properties p = new Properties();
        p.setProperty("hibernate.connection.driver_class", "com.mysql.jdbc.Driver");
        p.setProperty("hibernate.connection.url", "jdbc:mysql://" + host + "/" + db);
        p.setProperty("hibernate.connection.characterEncoding", "UTF-8");
        p.setProperty("hibernate.connection.useUnicode", "true");
        p.setProperty("hibernate.connection.username", user);
        p.setProperty("hibernate.connection.password", password);
        p.setProperty("hibernate.connection.pool_size", "1");
        p.setProperty("hibernate.dialect", "org.hibernate.dialect.MySQLDialect");
        p.setProperty("hibernate.current_session_context_class", "thread");
        p.setProperty("hibernate.cache.provider_class", "org.hibernate.cache.NoCacheProvider");
        p.setProperty("hibernate.show_sql", "false");
        p.setProperty("hibernate.hbm2ddl.auto", "update");
        return p;
    }

    private static Configuration getConfiguration(DatabaseConfiguration config) {
        Configuration cfg = new Configuration().addClass(Category.class).addClass(MetaData.class).addClass(Page.class).addClass(PageMapLine.class).addProperties(WikiHibernateUtil.getProperties(config));
        return cfg;
    }
}

