/*
 * Decompiled with CFR 0.152.
 */
package de.tudarmstadt.ukp.wikipedia.api.hibernate;

import de.tudarmstadt.ukp.wikipedia.api.Wikipedia;
import de.tudarmstadt.ukp.wikipedia.api.hibernate.Page;
import de.tudarmstadt.ukp.wikipedia.api.hibernate.WikiHibernateUtil;
import java.io.Serializable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.LockOptions;
import org.hibernate.SessionFactory;

public class PageDAO {
    private final Log logger = LogFactory.getLog(this.getClass());
    private static final String PAGE_CLASS = "de.tudarmstadt.ukp.wikipedia.api.hibernate.Page";
    private final SessionFactory sessionFactory;
    private Wikipedia wiki;

    public PageDAO(Wikipedia pWiki) {
        this.wiki = pWiki;
        this.sessionFactory = this.getSessionFactory();
    }

    protected SessionFactory getSessionFactory() {
        try {
            return WikiHibernateUtil.getSessionFactory(this.wiki.getDatabaseConfiguration());
        }
        catch (Exception e) {
            this.logger.error((Object)"Could not locate SessionFactory in JNDI", (Throwable)e);
            throw new IllegalStateException("Could not locate SessionFactory in JNDI");
        }
    }

    public void persist(Page transientInstance) {
        this.logger.debug((Object)"persisting Page instance");
        try {
            this.sessionFactory.getCurrentSession().persist((Object)transientInstance);
            this.logger.debug((Object)"persist successful");
        }
        catch (RuntimeException re) {
            this.logger.error((Object)"persist failed", (Throwable)re);
            throw re;
        }
    }

    public void attachDirty(Page instance) {
        this.logger.debug((Object)"attaching dirty Page instance");
        try {
            this.sessionFactory.getCurrentSession().saveOrUpdate((Object)instance);
            this.logger.debug((Object)"attach successful");
        }
        catch (RuntimeException re) {
            this.logger.error((Object)"attach failed", (Throwable)re);
            throw re;
        }
    }

    public void attachClean(Page instance) {
        this.logger.debug((Object)"attaching clean Page instance");
        try {
            this.sessionFactory.getCurrentSession().buildLockRequest(LockOptions.NONE).lock((Object)instance);
            this.logger.debug((Object)"attach successful");
        }
        catch (RuntimeException re) {
            this.logger.error((Object)"attach failed", (Throwable)re);
            throw re;
        }
    }

    public void delete(Page persistentInstance) {
        this.logger.debug((Object)"deleting Page instance");
        try {
            this.sessionFactory.getCurrentSession().delete((Object)persistentInstance);
            this.logger.debug((Object)"delete successful");
        }
        catch (RuntimeException re) {
            this.logger.error((Object)"delete failed", (Throwable)re);
            throw re;
        }
    }

    public Page merge(Page detachedInstance) {
        this.logger.debug((Object)"merging Page instance");
        try {
            Page result = (Page)this.sessionFactory.getCurrentSession().merge((Object)detachedInstance);
            this.logger.debug((Object)"merge successful");
            return result;
        }
        catch (RuntimeException re) {
            this.logger.error((Object)"merge failed", (Throwable)re);
            throw re;
        }
    }

    public Page findById(Long id) {
        this.logger.debug((Object)("getting Page instance with id: " + id));
        try {
            Page instance = (Page)this.sessionFactory.getCurrentSession().get(PAGE_CLASS, (Serializable)id);
            if (instance == null) {
                this.logger.debug((Object)"get successful, no instance found");
            } else {
                this.logger.debug((Object)"get successful, instance found");
            }
            return instance;
        }
        catch (RuntimeException re) {
            this.logger.error((Object)"get failed", (Throwable)re);
            throw re;
        }
    }
}

