/*
 * Decompiled with CFR 0.152.
 */
package de.tudarmstadt.ukp.wikipedia.api.hibernate;

import de.tudarmstadt.ukp.wikipedia.api.Wikipedia;
import de.tudarmstadt.ukp.wikipedia.api.hibernate.Category;
import de.tudarmstadt.ukp.wikipedia.api.hibernate.WikiHibernateUtil;
import java.io.Serializable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.LockOptions;
import org.hibernate.SessionFactory;

public class CategoryDAO {
    private final Log logger = LogFactory.getLog(this.getClass());
    private static final String CATEGORY_CLASS = "de.tudarmstadt.ukp.wikipedia.api.hibernate.Category";
    private final SessionFactory sessionFactory;
    private Wikipedia wiki;

    public CategoryDAO(Wikipedia pWiki) {
        this.wiki = pWiki;
        this.sessionFactory = this.getSessionFactory();
    }

    protected SessionFactory getSessionFactory() {
        try {
            return WikiHibernateUtil.getSessionFactory(this.wiki.getDatabaseConfiguration());
        }
        catch (Exception e) {
            this.logger.error((Object)"Could not locate SessionFactory in JNDI", (Throwable)e);
            throw new IllegalStateException("Could not locate SessionFactory in JNDI");
        }
    }

    public void persist(Category transientInstance) {
        this.logger.debug((Object)"persisting Category instance");
        try {
            this.sessionFactory.getCurrentSession().persist((Object)transientInstance);
            this.logger.debug((Object)"persist successful");
        }
        catch (RuntimeException re) {
            this.logger.error((Object)"persist failed", (Throwable)re);
            throw re;
        }
    }

    public void attachDirty(Category instance) {
        this.logger.debug((Object)"attaching dirty Category instance");
        try {
            this.sessionFactory.getCurrentSession().saveOrUpdate((Object)instance);
            this.logger.debug((Object)"attach successful");
        }
        catch (RuntimeException re) {
            this.logger.error((Object)"attach failed", (Throwable)re);
            throw re;
        }
    }

    public void attachClean(Category instance) {
        this.logger.debug((Object)"attaching clean Category instance");
        try {
            this.sessionFactory.getCurrentSession().buildLockRequest(LockOptions.NONE).lock((Object)instance);
            this.logger.debug((Object)"attach successful");
        }
        catch (RuntimeException re) {
            this.logger.error((Object)"attach failed", (Throwable)re);
            throw re;
        }
    }

    public void delete(Category persistentInstance) {
        this.logger.debug((Object)"deleting Category instance");
        try {
            this.sessionFactory.getCurrentSession().delete((Object)persistentInstance);
            this.logger.debug((Object)"delete successful");
        }
        catch (RuntimeException re) {
            this.logger.error((Object)"delete failed", (Throwable)re);
            throw re;
        }
    }

    public Category merge(Category detachedInstance) {
        this.logger.debug((Object)"merging Category instance");
        try {
            Category result = (Category)this.sessionFactory.getCurrentSession().merge((Object)detachedInstance);
            this.logger.debug((Object)"merge successful");
            return result;
        }
        catch (RuntimeException re) {
            this.logger.error((Object)"merge failed", (Throwable)re);
            throw re;
        }
    }

    public Category findById(Long id) {
        this.logger.debug((Object)("getting Category instance with id: " + id));
        try {
            Category instance = (Category)this.sessionFactory.getCurrentSession().get(CATEGORY_CLASS, (Serializable)id);
            if (instance == null) {
                this.logger.debug((Object)"get successful, no instance found");
            } else {
                this.logger.debug((Object)"get successful, instance found");
            }
            return instance;
        }
        catch (RuntimeException re) {
            this.logger.error((Object)"get failed", (Throwable)re);
            throw re;
        }
    }
}

