/*
 * Decompiled with CFR 0.152.
 */
package de.tudarmstadt.ukp.wikipedia.api;

import de.tudarmstadt.ukp.wikipedia.api.Category;
import de.tudarmstadt.ukp.wikipedia.api.CategoryGraph;
import de.tudarmstadt.ukp.wikipedia.api.Page;
import de.tudarmstadt.ukp.wikipedia.api.Wikipedia;
import de.tudarmstadt.ukp.wikipedia.api.exception.WikiApiException;
import de.tudarmstadt.ukp.wikipedia.api.exception.WikiPageNotFoundException;
import de.tudarmstadt.ukp.wikipedia.util.ApiUtilities;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.Session;

public class WikipediaInfo {
    private final Log logger = LogFactory.getLog(this.getClass());
    private Iterable<Page> pages;
    private double averageFanOut;
    private int numberOfPages;
    private Map<Integer, Integer> degreeDistribution;
    private Set<Integer> categorizedArticleSet;
    private Wikipedia wiki;

    public WikipediaInfo(Wikipedia pWiki) throws WikiApiException {
        this.wiki = pWiki;
        new WikipediaInfo(this.wiki.getPages());
    }

    public WikipediaInfo(Iterable<Page> pPages) throws WikiApiException {
        if (pPages == null) {
            throw new WikiApiException("The page set has to be initialized.");
        }
        this.pages = pPages;
        this.averageFanOut = -1.0;
        this.degreeDistribution = new HashMap<Integer, Integer>();
        this.categorizedArticleSet = new HashSet<Integer>();
        this.numberOfPages = 0;
        while (this.pages.iterator().hasNext()) {
            ++this.numberOfPages;
            this.pages.iterator().next();
        }
    }

    private double computeAverageFanOut(Iterable<Page> pages) {
        HashSet<Integer> pageIDs = new HashSet<Integer>();
        while (pages.iterator().hasNext()) {
            pageIDs.add(pages.iterator().next().getPageId());
        }
        if (pageIDs == null) {
            this.logger.error((Object)"Cannot compute average fan-out of an empty page set.");
            return 0.0;
        }
        int fanOutCounter = 0;
        Session session = this.wiki.__getHibernateSession();
        session.beginTransaction();
        for (Object[] row : session.createQuery("select page.outLinks, page.pageId from Page as page").list()) {
            Set outLinks = (Set)row[0];
            Integer pageId = (Integer)row[1];
            if (!pageIDs.contains(pageId)) continue;
            fanOutCounter += outLinks.size();
        }
        session.getTransaction().commit();
        return (double)fanOutCounter / (double)this.getNumberOfPages();
    }

    public double getAverageFanOut() {
        if (this.averageFanOut < 0.0) {
            this.averageFanOut = this.computeAverageFanOut(this.pages);
        }
        return this.averageFanOut;
    }

    public int getNumberOfPages() {
        return this.numberOfPages;
    }

    private Map<Integer, Set<Integer>> getCategoryArticleMap(Wikipedia pWiki, Set<Integer> pNodes) throws WikiPageNotFoundException {
        HashMap<Integer, Set<Integer>> categoryArticleMap = new HashMap<Integer, Set<Integer>>();
        int progress = 0;
        for (int node : pNodes) {
            ApiUtilities.printProgressInfo(++progress, pNodes.size(), 10, ApiUtilities.ProgressInfoMode.TEXT, "Getting category-article map.");
            Category cat = pWiki.getCategory(node);
            if (cat != null) {
                HashSet<Integer> pages = new HashSet<Integer>(cat.__getPages());
                categoryArticleMap.put(node, pages);
                continue;
            }
            this.logger.info((Object)(node + " is not a category."));
        }
        return categoryArticleMap;
    }

    public void getGraphParameters(CategoryGraph catGraph) {
        double startTime = System.currentTimeMillis();
        this.logger.error((Object)catGraph.getGraphInfo());
        double endTime = ((double)System.currentTimeMillis() - startTime) / 1000.0;
        this.logger.error((Object)(endTime + "s"));
    }

    public void getOverlapping(Wikipedia pWiki, CategoryGraph catGraph) throws WikiApiException {
        double startTime = System.currentTimeMillis();
        int articlesWithOverlappingCategories = this.getArticlesWithOverlappingCategories(pWiki, catGraph);
        double overlappingCategoriesRatio = (double)articlesWithOverlappingCategories / (double)pWiki.getMetaData().getNumberOfPages();
        this.logger.error((Object)(articlesWithOverlappingCategories + " - " + pWiki.getMetaData().getNumberOfPages() + " - " + overlappingCategoriesRatio));
        double endTime = ((double)System.currentTimeMillis() - startTime) / 1000.0;
        this.logger.error((Object)(endTime + "ms"));
    }

    private int getArticlesWithOverlappingCategories(Wikipedia pWiki, CategoryGraph pGraph) throws WikiPageNotFoundException {
        HashSet<Integer> overlappingArticles = new HashSet<Integer>();
        Set nodes = pGraph.getGraph().vertexSet();
        Map<Integer, Set<Integer>> categoryArticleMap = this.getCategoryArticleMap(pWiki, nodes);
        Object[] nodeArray = nodes.toArray();
        Arrays.sort(nodeArray);
        int progress = 0;
        for (int i = 0; i < nodes.size(); ++i) {
            ApiUtilities.printProgressInfo(++progress, nodes.size(), 100, ApiUtilities.ProgressInfoMode.TEXT, "");
            int outerNode = (Integer)nodeArray[i];
            for (int j = i + 1; j < nodes.size(); ++j) {
                int innerNode = (Integer)nodeArray[j];
                Set<Integer> outerPages = categoryArticleMap.get(outerNode);
                Set<Integer> innerPages = categoryArticleMap.get(innerNode);
                for (int outerPage : outerPages) {
                    if (!innerPages.contains(outerPage) || overlappingArticles.contains(outerPage)) continue;
                    overlappingArticles.add(outerPage);
                }
            }
        }
        return overlappingArticles.size();
    }

    public void getCategorizedArticles(Wikipedia pWiki, CategoryGraph catGraph) throws WikiApiException {
        double startTime = System.currentTimeMillis();
        int numberOfCategorizedArticles = this.getNumberOfCategorizedArticles(pWiki, catGraph);
        double categorizedArticlesRatio = (double)numberOfCategorizedArticles / (double)pWiki.getMetaData().getNumberOfPages();
        this.logger.info((Object)("Categorized articles: " + numberOfCategorizedArticles));
        this.logger.info((Object)("All articles:         " + pWiki.getMetaData().getNumberOfPages()));
        this.logger.info((Object)("Ratio:                " + categorizedArticlesRatio));
        double endTime = ((double)System.currentTimeMillis() - startTime) / 1000.0;
        this.logger.error((Object)(endTime + "ms"));
    }

    public double getAveragePathLengthFromRoot(Wikipedia pWiki, CategoryGraph connectedCatGraph) throws WikiApiException {
        Category rootCategory = pWiki.getMetaData().getMainCategory();
        int root = rootCategory.getPageId();
        int pathLengthSum = this.computeShortestPathLenghts(root, connectedCatGraph);
        return (double)pathLengthSum / (double)(connectedCatGraph.getGraph().vertexSet().size() - 1);
    }

    public int getNumberOfCategorizedArticles(Wikipedia pWiki, CategoryGraph catGraph) throws WikiApiException {
        if (this.categorizedArticleSet == null) {
            this.iterateCategoriesGetArticles(pWiki, catGraph);
        }
        return this.categorizedArticleSet.size();
    }

    public Map<Integer, Integer> getDistributionOfArticlesByCategory(Wikipedia pWiki, CategoryGraph catGraph) throws WikiPageNotFoundException {
        if (this.degreeDistribution == null) {
            this.iterateCategoriesGetArticles(pWiki, catGraph);
        }
        return this.degreeDistribution;
    }

    private void iterateCategoriesGetArticles(Wikipedia pWiki, CategoryGraph catGraph) throws WikiPageNotFoundException {
        HashMap<Integer, Integer> localDegreeDistribution = new HashMap<Integer, Integer>();
        HashSet<Integer> localCategorizedArticleSet = new HashSet<Integer>();
        Set categoryNodes = catGraph.getGraph().vertexSet();
        int progress = 0;
        Iterator i$ = categoryNodes.iterator();
        while (i$.hasNext()) {
            int node = (Integer)i$.next();
            ApiUtilities.printProgressInfo(++progress, categoryNodes.size(), 100, ApiUtilities.ProgressInfoMode.TEXT, "iterate over categories");
            Category cat = pWiki.getCategory(node);
            if (cat != null) {
                HashSet<Integer> pages = new HashSet<Integer>(cat.__getPages());
                int numberOfArticles = pages.size();
                if (localDegreeDistribution.containsKey(numberOfArticles)) {
                    int count = (Integer)localDegreeDistribution.get(numberOfArticles);
                    localDegreeDistribution.put(numberOfArticles, ++count);
                } else {
                    localDegreeDistribution.put(numberOfArticles, 1);
                }
                Iterator i$2 = pages.iterator();
                while (i$2.hasNext()) {
                    int page = (Integer)i$2.next();
                    if (localCategorizedArticleSet.contains(page)) continue;
                    localCategorizedArticleSet.add(page);
                }
                continue;
            }
            this.logger.info((Object)(node + " is not a category."));
        }
        this.degreeDistribution = localDegreeDistribution;
        this.categorizedArticleSet = localCategorizedArticleSet;
    }

    private int computeShortestPathLenghts(int pStartNode, CategoryGraph catGraph) {
        int shortestPathLengthSum = 0;
        HashSet<Integer> alreadyExpanded = new HashSet<Integer>();
        ArrayList<int[]> queue = new ArrayList<int[]>();
        int[] innerList = new int[]{pStartNode, 0};
        queue.add(innerList);
        while (!queue.isEmpty()) {
            int[] queueElement = (int[])queue.get(0);
            int currentNode = queueElement[0];
            int distance = queueElement[1];
            queue.remove(0);
            if (alreadyExpanded.contains(currentNode)) continue;
            alreadyExpanded.add(currentNode);
            shortestPathLengthSum += distance;
            Set<Integer> neighbors = catGraph.getNeighbors(currentNode);
            for (int neighbor : neighbors) {
                if (alreadyExpanded.contains(neighbor)) continue;
                int[] tmpList = new int[]{neighbor, distance + 1};
                queue.add(tmpList);
            }
        }
        return shortestPathLengthSum;
    }
}

