/*
 * Decompiled with CFR 0.152.
 */
package de.tudarmstadt.ukp.wikipedia.api;

import de.tudarmstadt.ukp.wikipedia.api.Category;
import de.tudarmstadt.ukp.wikipedia.api.CategoryIterable;
import de.tudarmstadt.ukp.wikipedia.api.DatabaseConfiguration;
import de.tudarmstadt.ukp.wikipedia.api.MetaData;
import de.tudarmstadt.ukp.wikipedia.api.Page;
import de.tudarmstadt.ukp.wikipedia.api.PageIterable;
import de.tudarmstadt.ukp.wikipedia.api.PageQuery;
import de.tudarmstadt.ukp.wikipedia.api.PageQueryIterable;
import de.tudarmstadt.ukp.wikipedia.api.Title;
import de.tudarmstadt.ukp.wikipedia.api.TitleIterable;
import de.tudarmstadt.ukp.wikipedia.api.ValueComparator;
import de.tudarmstadt.ukp.wikipedia.api.WikiConstants;
import de.tudarmstadt.ukp.wikipedia.api.exception.WikiApiException;
import de.tudarmstadt.ukp.wikipedia.api.exception.WikiInitializationException;
import de.tudarmstadt.ukp.wikipedia.api.exception.WikiPageNotFoundException;
import de.tudarmstadt.ukp.wikipedia.api.exception.WikiTitleParsingException;
import de.tudarmstadt.ukp.wikipedia.api.hibernate.WikiHibernateUtil;
import de.tudarmstadt.ukp.wikipedia.parser.mediawiki.MediaWikiParser;
import de.tudarmstadt.ukp.wikipedia.parser.mediawiki.MediaWikiParserFactory;
import de.tudarmstadt.ukp.wikipedia.util.distance.LevenshteinStringDistance;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.Query;
import org.hibernate.Session;

public class Wikipedia
implements WikiConstants {
    private final Log logger = LogFactory.getLog(this.getClass());
    private final WikiConstants.Language language;
    private final DatabaseConfiguration dbConfig;
    private final MediaWikiParser parser;
    private final Map<Integer, Long> idMapPages;
    private final Map<Integer, Long> idMapCategories;
    private final MetaData metaData;

    public Wikipedia(DatabaseConfiguration dbConfig) throws WikiInitializationException {
        this.logger.info((Object)"Creating Wikipedia object.");
        this.language = dbConfig.getLanguage();
        this.dbConfig = dbConfig;
        this.idMapPages = new HashMap<Integer, Long>();
        this.idMapCategories = new HashMap<Integer, Long>();
        this.metaData = new MetaData(this);
        MediaWikiParserFactory pf = new MediaWikiParserFactory(this.language);
        this.parser = pf.createParser();
    }

    public Page getPage(String title) throws WikiApiException {
        Page page = new Page(this, title);
        return page;
    }

    public Page getPage(int pageId) throws WikiApiException {
        Page page = new Page(this, pageId);
        return page;
    }

    public Title getTitle(int pageId) throws WikiApiException {
        Session session = this.__getHibernateSession();
        session.beginTransaction();
        Object returnValue = session.createSQLQuery("select p.name from PageMapLine as p where p.id = ?").setInteger(0, pageId).uniqueResult();
        session.getTransaction().commit();
        String title = (String)returnValue;
        if (title == null) {
            throw new WikiPageNotFoundException();
        }
        return new Title(title);
    }

    public List<Integer> getPageIds(String title) throws WikiApiException {
        Session session = this.__getHibernateSession();
        session.beginTransaction();
        Iterator results = session.createQuery("select p.pageID from PageMapLine as p where p.name = ?").setString(0, title).list().iterator();
        session.getTransaction().commit();
        if (!results.hasNext()) {
            throw new WikiPageNotFoundException();
        }
        LinkedList<Integer> resultList = new LinkedList<Integer>();
        while (results.hasNext()) {
            resultList.add((Integer)results.next());
        }
        return resultList;
    }

    public Page getArticleForDiscussionPage(Page discussionPage) throws WikiApiException {
        if (discussionPage.isDiscussion()) {
            String title = discussionPage.getTitle().getPlainTitle().replaceAll("Discussion:", "");
            if (title.contains("/")) {
                title = title.split("/")[0];
            }
            return this.getPage(title);
        }
        return discussionPage;
    }

    public Page getDiscussionPage(int articlePageId) throws WikiApiException {
        return this.getDiscussionPage(this.getPage(articlePageId));
    }

    public Page getDiscussionPage(String title) throws WikiApiException {
        return this.getDiscussionPage(this.getPage(title));
    }

    public Page getDiscussionPage(Page articlePage) throws WikiApiException {
        String articleTitle = articlePage.getTitle().toString();
        if (articleTitle.startsWith("Discussion:")) {
            return articlePage;
        }
        return new Page(this, "Discussion:" + articleTitle);
    }

    public Iterable<Page> getDiscussionArchives(int articlePageId) throws WikiApiException {
        return this.getDiscussionArchives(this.getPage(articlePageId));
    }

    public Iterable<Page> getDiscussionArchives(String title) throws WikiApiException {
        return this.getDiscussionArchives(this.getPage(title));
    }

    public Iterable<Page> getDiscussionArchives(Page articlePage) throws WikiApiException {
        String articleTitle = articlePage.getTitle().toString();
        if (!articleTitle.startsWith("Discussion:")) {
            articleTitle = "Discussion:" + articleTitle;
        }
        Session session = this.__getHibernateSession();
        session.beginTransaction();
        LinkedList<Page> discussionArchives = new LinkedList<Page>();
        Query query = session.createQuery("SELECT pageID FROM PageMapLine where name like ?");
        query.setString(0, articleTitle + "/%");
        Iterator results = query.list().iterator();
        session.getTransaction().commit();
        while (results.hasNext()) {
            int pageID = (Integer)results.next();
            discussionArchives.add(this.getPage(pageID));
        }
        return discussionArchives;
    }

    protected Map<Page, Double> getSimilarPages(String pPattern, int pSize) throws WikiApiException {
        int pageID;
        Title title = new Title(pPattern);
        String pattern = title.getWikiStyleTitle();
        HashMap<Page, Double> pageMap = new HashMap<Page, Double>();
        HashMap<Integer, Double> distanceMap = new HashMap<Integer, Double>();
        Session session = this.__getHibernateSession();
        session.beginTransaction();
        for (Object[] row : session.createQuery("select pml.pageID, pml.name from PageMapLine as pml").list()) {
            pageID = (Integer)row[0];
            String pageName = (String)row[1];
            double distance = new LevenshteinStringDistance().distance(pageName, pattern);
            distanceMap.put(pageID, distance);
            if (distanceMap.size() <= pSize) continue;
            TreeSet<Map.Entry<Integer, Double>> valueSortedSet = new TreeSet<Map.Entry<Integer, Double>>(new ValueComparator());
            valueSortedSet.addAll(distanceMap.entrySet());
            Iterator it = valueSortedSet.iterator();
            if (!it.hasNext()) continue;
            Map.Entry entry = (Map.Entry)it.next();
            distanceMap.remove(entry.getKey());
        }
        session.getTransaction().commit();
        Iterator i$ = distanceMap.keySet().iterator();
        while (i$.hasNext()) {
            pageID = (Integer)i$.next();
            Page page = null;
            try {
                page = this.getPage(pageID);
            }
            catch (WikiPageNotFoundException e) {
                this.logger.error((Object)("Page with pageID " + pageID + " could not be found. Fatal error. Terminating."));
                e.printStackTrace();
                System.exit(1);
            }
            pageMap.put(page, (Double)distanceMap.get(pageID));
        }
        return pageMap;
    }

    public Category getCategory(String title) throws WikiApiException {
        Category cat = new Category(this, title);
        return cat;
    }

    public Category getCategory(int pageId) {
        long hibernateId = this.__getCategoryHibernateId(pageId);
        if (hibernateId == -1L) {
            return null;
        }
        try {
            Category cat = new Category(this, hibernateId);
            return cat;
        }
        catch (WikiPageNotFoundException e) {
            return null;
        }
    }

    public Iterable<Category> getCategories() {
        return new CategoryIterable(this);
    }

    protected Iterable<Category> getCategories(int bufferSize) {
        return new CategoryIterable(this, bufferSize);
    }

    protected Set<Integer> __getCategories() {
        Session session = this.__getHibernateSession();
        session.beginTransaction();
        List idList = session.createQuery("select cat.pageId from Category as cat").list();
        HashSet<Integer> categorySet = new HashSet<Integer>(idList);
        session.getTransaction().commit();
        return categorySet;
    }

    public Iterable<Page> getPages() {
        return new PageIterable(this, false);
    }

    protected Iterable<Page> getPages(int bufferSize) {
        return new PageIterable(this, false, bufferSize);
    }

    protected Set<Integer> __getPages() {
        Session session = this.__getHibernateSession();
        session.beginTransaction();
        List idList = session.createQuery("select page.pageId from Page as page").list();
        HashSet<Integer> pageSet = new HashSet<Integer>(idList);
        session.getTransaction().commit();
        return pageSet;
    }

    public Iterable<Integer> getPageIds() {
        return this.__getPages();
    }

    public Iterable<Page> getPages(PageQuery query) throws WikiApiException {
        return new PageQueryIterable(this, query);
    }

    public Iterable<Page> getArticles() {
        return new PageIterable(this, true);
    }

    public Iterable<Title> getTitles() {
        return new TitleIterable(this);
    }

    public WikiConstants.Language getLanguage() {
        return this.language;
    }

    public boolean existsPage(String title) {
        Title t;
        if (title == null || title.length() == 0) {
            return false;
        }
        try {
            t = new Title(title);
        }
        catch (WikiTitleParsingException e) {
            return false;
        }
        String encodedTitle = t.getWikiStyleTitle();
        Session session = this.__getHibernateSession();
        session.beginTransaction();
        Object returnValue = session.createSQLQuery("select p.id from PageMapLine as p where p.name = ? COLLATE utf8_bin").setString(0, encodedTitle).uniqueResult();
        session.getTransaction().commit();
        return returnValue != null;
    }

    public boolean existsPage(int pageID) {
        if (pageID < 0) {
            return false;
        }
        Session session = this.__getHibernateSession();
        session.beginTransaction();
        List returnList = session.createSQLQuery("select p.id from PageMapLine as p where p.pageID = ?").setInteger(0, pageID).list();
        session.getTransaction().commit();
        return returnList.size() != 0;
    }

    protected long __getPageHibernateId(int pageID) {
        long hibernateID = -1L;
        if (this.idMapPages.containsKey(pageID)) {
            return this.idMapPages.get(pageID);
        }
        Session session = this.__getHibernateSession();
        session.beginTransaction();
        Object retObjectPage = session.createQuery("select page.id from Page as page where page.pageId = ?").setInteger(0, pageID).uniqueResult();
        session.getTransaction().commit();
        if (retObjectPage != null) {
            hibernateID = (Long)retObjectPage;
            this.idMapPages.put(pageID, hibernateID);
            return hibernateID;
        }
        return hibernateID;
    }

    protected long __getCategoryHibernateId(int pageID) {
        long hibernateID = -1L;
        if (this.idMapCategories.containsKey(pageID)) {
            return this.idMapCategories.get(pageID);
        }
        Session session = this.__getHibernateSession();
        session.beginTransaction();
        Object retObjectPage = session.createQuery("select cat.id from Category as cat where cat.pageId = ?").setInteger(0, pageID).uniqueResult();
        session.getTransaction().commit();
        if (retObjectPage != null) {
            hibernateID = (Long)retObjectPage;
            this.idMapCategories.put(pageID, hibernateID);
        }
        return hibernateID;
    }

    public MetaData getMetaData() {
        return this.metaData;
    }

    public DatabaseConfiguration getDatabaseConfiguration() {
        return this.dbConfig;
    }

    protected Session __getHibernateSession() {
        return WikiHibernateUtil.getSessionFactory(this.dbConfig).getCurrentSession();
    }

    protected MediaWikiParser getParser() {
        return this.parser;
    }

    public String getWikipediaId() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getDatabaseConfiguration().getHost());
        sb.append("_");
        sb.append(this.getDatabaseConfiguration().getDatabase());
        sb.append("_");
        sb.append((Object)this.getDatabaseConfiguration().getLanguage());
        return sb.toString();
    }
}

