/*
 * Decompiled with CFR 0.152.
 */
package de.tudarmstadt.ukp.wikipedia.api;

import de.tudarmstadt.ukp.wikipedia.api.DatabaseConfiguration;
import de.tudarmstadt.ukp.wikipedia.api.Page;
import de.tudarmstadt.ukp.wikipedia.api.WikiConstants;
import de.tudarmstadt.ukp.wikipedia.api.Wikipedia;
import java.util.Iterator;

public class PerformanceTestPageIterator {
    public static void test(int numberOfPages, int bufferSize, Wikipedia wiki) {
        int counter;
        long from = System.currentTimeMillis();
        Iterator<Page> pages = wiki.getPages(bufferSize).iterator();
        for (counter = 0; counter < numberOfPages && pages.hasNext(); ++counter) {
            pages.next();
        }
        long to = System.currentTimeMillis();
        System.out.println("RetrievedPages  : " + counter);
        System.out.println("Used Buffer Size: " + bufferSize);
        System.out.println("Time            : " + (to - from) + "ms");
        System.out.println("------------------------------");
    }

    public static void main(String[] args) throws Exception {
        DatabaseConfiguration db = new DatabaseConfiguration();
        db.setDatabase("wikiapi_uk");
        db.setHost("bender.ukp.informatik.tu-darmstadt.de");
        db.setUser("student");
        db.setPassword("student");
        db.setLanguage(WikiConstants.Language.ukrainian);
        Wikipedia wiki = new Wikipedia(db);
        System.out.println("Test: retrieve 4000 pages ...");
        PerformanceTestPageIterator.test(4000, 1, wiki);
        PerformanceTestPageIterator.test(4000, 10, wiki);
        PerformanceTestPageIterator.test(4000, 50, wiki);
        PerformanceTestPageIterator.test(4000, 100, wiki);
        PerformanceTestPageIterator.test(4000, 200, wiki);
        PerformanceTestPageIterator.test(4000, 500, wiki);
    }
}

