/*
 * Decompiled with CFR 0.152.
 */
package de.tudarmstadt.ukp.wikipedia.api;

import de.tudarmstadt.ukp.wikipedia.api.DatabaseConfiguration;
import de.tudarmstadt.ukp.wikipedia.api.Page;
import de.tudarmstadt.ukp.wikipedia.api.WikiConstants;
import de.tudarmstadt.ukp.wikipedia.api.Wikipedia;
import de.tudarmstadt.ukp.wikipedia.api.exception.WikiApiException;
import de.tudarmstadt.ukp.wikipedia.api.exception.WikiPageNotFoundException;
import de.tudarmstadt.ukp.wikipedia.util.GraphUtilities;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class PerformanceTest
implements WikiConstants {
    private final Log logger = LogFactory.getLog(this.getClass());
    private final Wikipedia wiki;
    private final Set<Integer> pageIDs;
    private List<List<Integer>> randomIdList;
    private List<List<String>> randomTitleList;
    int maxiCycles = 5;
    int pageCycles = 50;

    public static void main(String[] args) throws WikiApiException {
        DatabaseConfiguration dbConfig = new DatabaseConfiguration();
        dbConfig.setDatabase("wikiapi_en");
        dbConfig.setHost("bender.ukp.informatik.tu-darmstadt.de");
        dbConfig.setUser("wikiapi");
        dbConfig.setPassword("wikiapitk");
        dbConfig.setLanguage(WikiConstants.Language.english);
        Wikipedia wiki = new Wikipedia(dbConfig);
        PerformanceTest pt = new PerformanceTest(wiki);
        System.out.println("intern page loading");
        pt.loadPagesTest("intern");
        System.out.println();
        System.out.println("extern page loading");
        pt.loadPagesTest("extern");
        System.out.println();
        System.out.println("intern page loading and field accessing");
        pt.loadPagesAndAccessFieldsTest("intern");
        System.out.println();
        System.out.println("extern page loading and field accessing");
        pt.loadPagesAndAccessFieldsTest("extern");
        System.out.println();
    }

    public PerformanceTest(Wikipedia pWiki) throws WikiApiException {
        this.wiki = pWiki;
        this.pageIDs = this.wiki.__getPages();
        this.initializeLists(this.pageIDs);
    }

    private void initializeLists(Set<Integer> allPageIDs) throws WikiApiException {
        this.randomIdList = new ArrayList<List<Integer>>();
        this.randomTitleList = new ArrayList<List<String>>();
        for (int j = 0; j < this.maxiCycles; ++j) {
            Set<Integer> randomPageIds = GraphUtilities.getRandomPageSubset(allPageIDs, this.pageCycles);
            ArrayList<Integer> randomPageIdList = new ArrayList<Integer>(randomPageIds);
            this.randomIdList.add(randomPageIdList);
            ArrayList<String> randomPageTitles = new ArrayList<String>();
            for (int id : randomPageIds) {
                Page p = this.wiki.getPage(id);
                randomPageTitles.add(p.getTitle().getWikiStyleTitle());
            }
            this.randomTitleList.add(randomPageTitles);
        }
    }

    private void loadPagesTest(String mode) throws WikiApiException {
        double averageThroughput = 0.0;
        for (int j = 0; j < this.maxiCycles; ++j) {
            double averageTime = 0.0;
            for (int i = 0; i < this.pageCycles; ++i) {
                long id = this.wiki.__getPageHibernateId(this.randomIdList.get(j).get(i));
                String title = this.randomTitleList.get(j).get(i);
                double startTime = System.currentTimeMillis();
                if (mode.equals("intern")) {
                    this.loadPage(id);
                } else {
                    this.loadPage(title);
                }
                double elapsedTime = (double)System.currentTimeMillis() - startTime;
                averageTime += elapsedTime;
            }
            double throughput = (double)this.pageCycles / averageTime;
            averageThroughput += throughput;
            System.out.println("throughput: " + throughput + " pages/ms");
        }
        System.out.println("-----------------");
        System.out.println("average throughput: " + (averageThroughput /= (double)this.maxiCycles) + " pages/ms");
        System.out.println("average throughput: " + averageThroughput * 1000.0 + " pages/s");
        System.out.println("-----------------");
        System.out.println("");
    }

    private void loadPagesAndAccessFieldsTest(String mode) throws WikiApiException {
        double averageThroughput = 0.0;
        for (int j = 0; j < this.maxiCycles; ++j) {
            double averageTime = 0.0;
            for (int i = 0; i < this.pageCycles; ++i) {
                Set<Integer> page = GraphUtilities.getRandomPageSubset(this.pageIDs, 1);
                Iterator<Integer> it = page.iterator();
                int pageID = it.next();
                long id = this.wiki.__getPageHibernateId(pageID);
                double startTime = System.currentTimeMillis();
                if (mode.equals("intern")) {
                    this.loadPageAndAccessFields_intern(id);
                } else {
                    this.loadPageAndAccessFields_extern(id);
                }
                double elapsedTime = (double)System.currentTimeMillis() - startTime;
                averageTime += elapsedTime;
            }
            double throughput = (double)this.pageCycles / averageTime;
            averageThroughput += throughput;
            System.out.println("throughput: " + throughput + " pages/ms");
        }
        System.out.println("-----------------");
        System.out.println("average throughput: " + (averageThroughput /= (double)this.maxiCycles) + " pages/ms");
        System.out.println("average throughput: " + averageThroughput * 1000.0 + " pages/s");
        System.out.println("-----------------");
        System.out.println("");
    }

    private void loadPage(long id) throws WikiApiException {
        try {
            Page page = new Page(this.wiki, id);
        }
        catch (WikiPageNotFoundException wikiPageNotFoundException) {
            // empty catch block
        }
    }

    private void loadPage(String title) throws WikiApiException {
        try {
            Page page = this.wiki.getPage(title);
        }
        catch (WikiPageNotFoundException wikiPageNotFoundException) {
            // empty catch block
        }
    }

    private void loadPageAndAccessFields_intern(long id) throws WikiApiException {
        try {
            Page page = new Page(this.wiki, id);
            Set<Integer> inLinks = page.getInlinkIDs();
            Set<Integer> outLinks = page.getOutlinkIDs();
            String text = page.getText();
        }
        catch (WikiPageNotFoundException wikiPageNotFoundException) {
            // empty catch block
        }
    }

    private void loadPageAndAccessFields_extern(long id) throws WikiApiException {
        try {
            Page page = new Page(this.wiki, id);
            Set<Page> inLinks = page.getInlinks();
            Set<Page> outLinks = page.getOutlinks();
            String text = page.getText();
        }
        catch (WikiPageNotFoundException wikiPageNotFoundException) {
            // empty catch block
        }
    }
}

