/*
 * Decompiled with CFR 0.152.
 */
package de.tudarmstadt.ukp.wikipedia.api;

import de.tudarmstadt.ukp.wikipedia.api.Category;
import de.tudarmstadt.ukp.wikipedia.api.Title;
import de.tudarmstadt.ukp.wikipedia.api.WikiConstants;
import de.tudarmstadt.ukp.wikipedia.api.Wikipedia;
import de.tudarmstadt.ukp.wikipedia.api.exception.WikiApiException;
import de.tudarmstadt.ukp.wikipedia.api.exception.WikiPageNotFoundException;
import de.tudarmstadt.ukp.wikipedia.api.exception.WikiTitleParsingException;
import de.tudarmstadt.ukp.wikipedia.api.hibernate.PageDAO;
import de.tudarmstadt.ukp.wikipedia.parser.Link;
import de.tudarmstadt.ukp.wikipedia.parser.ParsedPage;
import de.tudarmstadt.ukp.wikipedia.util.UnmodifiableArraySet;
import java.math.BigInteger;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.hibernate.LockOptions;
import org.hibernate.Session;

public class Page
implements WikiConstants {
    private final Wikipedia wiki;
    private final PageDAO pageDAO;
    private de.tudarmstadt.ukp.wikipedia.api.hibernate.Page hibernatePage;
    private boolean isRedirect = false;

    protected Page(Wikipedia wiki, long id) throws WikiApiException {
        this.wiki = wiki;
        this.pageDAO = new PageDAO(wiki);
        this.fetchByHibernateId(id);
    }

    protected Page(Wikipedia wiki, int pageID) throws WikiApiException {
        this.wiki = wiki;
        this.pageDAO = new PageDAO(wiki);
        this.fetchByPageId(pageID);
    }

    public Page(Wikipedia wiki, String pName) throws WikiApiException {
        if (pName == null || pName.length() == 0) {
            throw new WikiPageNotFoundException();
        }
        this.wiki = wiki;
        this.pageDAO = new PageDAO(wiki);
        Title pageTitle = new Title(pName);
        this.fetchByTitle(pageTitle);
    }

    protected Page(Wikipedia wiki, long id, de.tudarmstadt.ukp.wikipedia.api.hibernate.Page hibernatePage) throws WikiApiException {
        this.wiki = wiki;
        this.pageDAO = new PageDAO(wiki);
        this.hibernatePage = hibernatePage;
    }

    private void fetchByHibernateId(long id) throws WikiApiException {
        Session session = this.wiki.__getHibernateSession();
        session.beginTransaction();
        this.hibernatePage = this.pageDAO.findById(id);
        session.getTransaction().commit();
        if (this.hibernatePage == null) {
            throw new WikiPageNotFoundException("No page with id " + id + " was found.");
        }
    }

    private void fetchByPageId(int pageID) throws WikiApiException {
        Session session = this.wiki.__getHibernateSession();
        session.beginTransaction();
        this.hibernatePage = (de.tudarmstadt.ukp.wikipedia.api.hibernate.Page)session.createQuery("from Page where pageId = ?").setInteger(0, pageID).uniqueResult();
        session.getTransaction().commit();
        if (this.hibernatePage == null) {
            throw new WikiPageNotFoundException("No page with page id " + pageID + " was found.");
        }
    }

    private void fetchByTitle(Title pTitle) throws WikiApiException {
        String searchString = pTitle.getWikiStyleTitle();
        Session session = this.wiki.__getHibernateSession();
        session.beginTransaction();
        Integer pageId = (Integer)session.createSQLQuery("select pml.pageID from PageMapLine as pml where pml.name = ? LIMIT 1").setString(0, searchString).uniqueResult();
        session.getTransaction().commit();
        if (pageId == null) {
            throw new WikiPageNotFoundException("No page with name " + searchString + " was found.");
        }
        this.fetchByPageId(pageId);
        if (searchString != null && !searchString.equals(this.getTitle().getRawTitleText())) {
            this.isRedirect = true;
        }
    }

    protected long __getId() {
        long id = this.hibernatePage.getId();
        return id;
    }

    public int getPageId() {
        int id = this.hibernatePage.getPageId();
        return id;
    }

    public Set<Category> getCategories() {
        Session session = this.wiki.__getHibernateSession();
        session.beginTransaction();
        session.buildLockRequest(LockOptions.NONE).lock((Object)this.hibernatePage);
        UnmodifiableArraySet<Integer> tmp = new UnmodifiableArraySet<Integer>(this.hibernatePage.getCategories());
        session.getTransaction().commit();
        HashSet<Category> categories = new HashSet<Category>();
        Iterator i$ = tmp.iterator();
        while (i$.hasNext()) {
            int pageID = (Integer)i$.next();
            categories.add(this.wiki.getCategory(pageID));
        }
        return categories;
    }

    public int getNumberOfCategories() {
        BigInteger nrOfCategories = new BigInteger("0");
        long id = this.__getId();
        Session session = this.wiki.__getHibernateSession();
        session.beginTransaction();
        Object returnValue = session.createSQLQuery("select count(pages) from page_categories where id = ?").setLong(0, id).uniqueResult();
        session.getTransaction().commit();
        if (returnValue != null) {
            nrOfCategories = (BigInteger)returnValue;
        }
        return nrOfCategories.intValue();
    }

    public Set<Page> getInlinks() {
        Session session = this.wiki.__getHibernateSession();
        session.beginTransaction();
        session.buildLockRequest(LockOptions.NONE).lock((Object)this.hibernatePage);
        UnmodifiableArraySet<Integer> pageIDs = new UnmodifiableArraySet<Integer>(this.hibernatePage.getInLinks());
        session.getTransaction().commit();
        HashSet<Page> pages = new HashSet<Page>();
        Iterator i$ = pageIDs.iterator();
        while (i$.hasNext()) {
            int pageID = (Integer)i$.next();
            try {
                pages.add(this.wiki.getPage(pageID));
            }
            catch (WikiApiException e) {}
        }
        return pages;
    }

    public int getNumberOfInlinks() {
        BigInteger nrOfInlinks = new BigInteger("0");
        long id = this.__getId();
        Session session = this.wiki.__getHibernateSession();
        session.beginTransaction();
        Object returnValue = session.createSQLQuery("select count(pi.inLinks) from page_inlinks as pi where pi.id = ?").setLong(0, id).uniqueResult();
        session.getTransaction().commit();
        if (returnValue != null) {
            nrOfInlinks = (BigInteger)returnValue;
        }
        return nrOfInlinks.intValue();
    }

    public Set<Integer> getInlinkIDs() {
        HashSet<Integer> tmpSet = new HashSet<Integer>();
        Session session = this.wiki.__getHibernateSession();
        session.beginTransaction();
        session.buildLockRequest(LockOptions.NONE).lock((Object)this.hibernatePage);
        tmpSet.addAll(this.hibernatePage.getInLinks());
        session.getTransaction().commit();
        return tmpSet;
    }

    public Set<Page> getOutlinks() {
        Session session = this.wiki.__getHibernateSession();
        session.beginTransaction();
        session.buildLockRequest(LockOptions.NONE).lock((Object)this.hibernatePage);
        UnmodifiableArraySet<Integer> tmpSet = new UnmodifiableArraySet<Integer>(this.hibernatePage.getOutLinks());
        session.getTransaction().commit();
        HashSet<Page> pages = new HashSet<Page>();
        Iterator i$ = tmpSet.iterator();
        while (i$.hasNext()) {
            int pageID = (Integer)i$.next();
            try {
                pages.add(this.wiki.getPage(pageID));
            }
            catch (WikiApiException e) {}
        }
        return pages;
    }

    public int getNumberOfOutlinks() {
        BigInteger nrOfOutlinks = new BigInteger("0");
        long id = this.__getId();
        Session session = this.wiki.__getHibernateSession();
        session.beginTransaction();
        Object returnValue = session.createSQLQuery("select count(outLinks) from page_outlinks where id = ?").setLong(0, id).uniqueResult();
        session.getTransaction().commit();
        if (returnValue != null) {
            nrOfOutlinks = (BigInteger)returnValue;
        }
        return nrOfOutlinks.intValue();
    }

    public Set<Integer> getOutlinkIDs() {
        HashSet<Integer> tmpSet = new HashSet<Integer>();
        Session session = this.wiki.__getHibernateSession();
        session.beginTransaction();
        session.buildLockRequest(LockOptions.NONE).lock((Object)this.hibernatePage);
        tmpSet.addAll(this.hibernatePage.getOutLinks());
        session.getTransaction().commit();
        return tmpSet;
    }

    public Title getTitle() throws WikiTitleParsingException {
        Session session = this.wiki.__getHibernateSession();
        session.beginTransaction();
        String name = this.hibernatePage.getName();
        session.getTransaction().commit();
        Title title = new Title(name);
        return title;
    }

    public Set<String> getRedirects() {
        Session session = this.wiki.__getHibernateSession();
        session.beginTransaction();
        session.buildLockRequest(LockOptions.NONE).lock((Object)this.hibernatePage);
        HashSet<String> tmpSet = new HashSet<String>(this.hibernatePage.getRedirects());
        session.getTransaction().commit();
        return tmpSet;
    }

    public String getText() {
        Session session = this.wiki.__getHibernateSession();
        session.beginTransaction();
        String text = this.hibernatePage.getText();
        session.getTransaction().commit();
        StringBuilder sb = new StringBuilder(text);
        int t = 0;
        boolean seenLineBreak = false;
        char breakQue = ' ';
        for (int s = 0; s < sb.length(); ++s) {
            boolean isLineBreak;
            char c = sb.charAt(s);
            boolean bl = isLineBreak = c == '\n' || c == '\r';
            if (isLineBreak) {
                if (seenLineBreak && c != breakQue) {
                    seenLineBreak = false;
                    continue;
                }
                seenLineBreak = true;
                breakQue = c;
            } else {
                seenLineBreak = false;
            }
            sb.setCharAt(t, isLineBreak ? (char)'\n' : (char)c);
            ++t;
        }
        sb.setLength(t);
        return sb.toString();
    }

    public boolean isDisambiguation() {
        Session session = this.wiki.__getHibernateSession();
        session.beginTransaction();
        boolean isDisambiguation = this.hibernatePage.getIsDisambiguation();
        session.getTransaction().commit();
        return isDisambiguation;
    }

    public boolean isRedirect() {
        return this.isRedirect;
    }

    public boolean isDiscussion() throws WikiTitleParsingException {
        return this.getTitle().getRawTitleText().startsWith("Discussion:");
    }

    public String getPlainText() throws WikiApiException {
        ParsedPage pp = this.getParsedPage();
        if (pp == null) {
            return "";
        }
        return this.getTitle().getPlainTitle() + " " + pp.getText();
    }

    public ParsedPage getParsedPage() {
        return this.wiki.getParser().parse(this.getText());
    }

    public Set<String> getInlinkAnchors() throws WikiTitleParsingException {
        HashSet<String> inAnchors = new HashSet<String>();
        for (Page p : this.getInlinks()) {
            ParsedPage pp = p.getParsedPage();
            if (pp == null) {
                return inAnchors;
            }
            for (Link l : pp.getLinks()) {
                String pageTitle = p.getTitle().getPlainTitle();
                String anchorText = l.getText();
                if (!l.getTarget().equals(pageTitle) || anchorText.equals(pageTitle)) continue;
                inAnchors.add(anchorText);
            }
        }
        return inAnchors;
    }

    public Map<String, Set<String>> getOutlinkAnchors() throws WikiTitleParsingException {
        HashMap<String, Set<String>> outAnchors = new HashMap<String, Set<String>>();
        ParsedPage pp = this.getParsedPage();
        if (pp == null) {
            return outAnchors;
        }
        for (Link l : pp.getLinks()) {
            String anchorText;
            if (l.getTarget().length() == 0) continue;
            String targetTitle = new Title(l.getTarget()).getPlainTitle();
            if (l.getType().equals((Object)Link.type.EXTERNAL) || l.getType().equals((Object)Link.type.IMAGE) || l.getType().equals((Object)Link.type.AUDIO) || l.getType().equals((Object)Link.type.VIDEO) || targetTitle.contains(":") || (anchorText = l.getText()).equals(targetTitle)) continue;
            Set anchors = outAnchors.containsKey(targetTitle) ? (Set)outAnchors.get(targetTitle) : new HashSet();
            anchors.add(anchorText);
            outAnchors.put(targetTitle, anchors);
        }
        return outAnchors;
    }

    protected String getPageInfo() throws WikiApiException {
        StringBuffer sb = new StringBuffer(1000);
        sb.append("ID             : " + this.__getId() + LF);
        sb.append("PageID         : " + this.getPageId() + LF);
        sb.append("Name           : " + this.getTitle() + LF);
        sb.append("Disambiguation : " + this.isDisambiguation() + LF);
        sb.append("Redirects" + LF);
        for (String redirect : this.getRedirects()) {
            sb.append("  " + redirect + LF);
        }
        sb.append("Categories" + LF);
        for (Category category : this.getCategories()) {
            sb.append("  " + category.getTitle() + LF);
        }
        sb.append("In-Links" + LF);
        for (Page inLink : this.getInlinks()) {
            sb.append("  " + inLink.getTitle() + LF);
        }
        sb.append("Out-Links" + LF);
        for (Page outLink : this.getOutlinks()) {
            sb.append("  " + outLink.getTitle() + LF);
        }
        return sb.toString();
    }
}

