/*
 * Decompiled with CFR 0.152.
 */
package de.tudarmstadt.ukp.wikipedia.api;

import de.tudarmstadt.ukp.wikipedia.api.Category;
import de.tudarmstadt.ukp.wikipedia.api.WikiConstants;
import de.tudarmstadt.ukp.wikipedia.api.Wikipedia;
import de.tudarmstadt.ukp.wikipedia.api.exception.WikiApiException;
import org.hibernate.LockMode;
import org.hibernate.Session;

public class MetaData
implements WikiConstants {
    private de.tudarmstadt.ukp.wikipedia.api.hibernate.MetaData hibernateMetaData;
    private Wikipedia wiki;

    protected MetaData(Wikipedia wiki) {
        this.wiki = wiki;
        Session session = this.wiki.__getHibernateSession();
        session.beginTransaction();
        this.hibernateMetaData = (de.tudarmstadt.ukp.wikipedia.api.hibernate.MetaData)session.createQuery("from MetaData").uniqueResult();
        session.getTransaction().commit();
    }

    public long getId() {
        Session session = this.wiki.__getHibernateSession();
        session.beginTransaction();
        session.lock((Object)this.hibernateMetaData, LockMode.NONE);
        long id = this.hibernateMetaData.getId();
        session.getTransaction().commit();
        return id;
    }

    public long getNumberOfCategories() {
        Session session = this.wiki.__getHibernateSession();
        session.beginTransaction();
        session.lock((Object)this.hibernateMetaData, LockMode.NONE);
        long nrofCategories = this.hibernateMetaData.getNrofCategories();
        session.getTransaction().commit();
        return nrofCategories;
    }

    public long getNumberOfPages() {
        Session session = this.wiki.__getHibernateSession();
        session.beginTransaction();
        session.lock((Object)this.hibernateMetaData, LockMode.NONE);
        long nrofPages = this.hibernateMetaData.getNrofPages();
        session.getTransaction().commit();
        return nrofPages;
    }

    public long getNumberOfDisambiguationPages() {
        Session session = this.wiki.__getHibernateSession();
        session.beginTransaction();
        session.lock((Object)this.hibernateMetaData, LockMode.NONE);
        long nrofDisambPages = this.hibernateMetaData.getNrofDisambiguationPages();
        session.getTransaction().commit();
        return nrofDisambPages;
    }

    public long getNumberOfRedirectPages() {
        Session session = this.wiki.__getHibernateSession();
        session.beginTransaction();
        session.lock((Object)this.hibernateMetaData, LockMode.NONE);
        long nrofRedirects = this.hibernateMetaData.getNrofRedirects();
        session.getTransaction().commit();
        return nrofRedirects;
    }

    public Category getDisambiguationCategory() throws WikiApiException {
        Session session = this.wiki.__getHibernateSession();
        session.beginTransaction();
        session.lock((Object)this.hibernateMetaData, LockMode.NONE);
        String disambCategoryTitle = this.hibernateMetaData.getDisambiguationCategory();
        session.getTransaction().commit();
        Category disambCategory = this.wiki.getCategory(disambCategoryTitle);
        return disambCategory;
    }

    public Category getMainCategory() throws WikiApiException {
        Session session = this.wiki.__getHibernateSession();
        session.beginTransaction();
        session.lock((Object)this.hibernateMetaData, LockMode.NONE);
        String mainCategoryTitle = this.hibernateMetaData.getMainCategory();
        session.getTransaction().commit();
        Category mainCategory = this.wiki.getCategory(mainCategoryTitle);
        return mainCategory;
    }

    public String getVersion() throws WikiApiException {
        Session session = this.wiki.__getHibernateSession();
        session.beginTransaction();
        session.lock((Object)this.hibernateMetaData, LockMode.NONE);
        String version = this.hibernateMetaData.getVersion();
        session.getTransaction().commit();
        return version;
    }

    public WikiConstants.Language getLanguage() {
        return this.wiki.getLanguage();
    }
}

