/*
 * Decompiled with CFR 0.152.
 */
package de.tudarmstadt.ukp.wikipedia.api;

import de.tudarmstadt.ukp.wikipedia.api.Category;
import de.tudarmstadt.ukp.wikipedia.api.CategoryGraph;
import de.tudarmstadt.ukp.wikipedia.api.Wikipedia;
import de.tudarmstadt.ukp.wikipedia.api.exception.WikiApiException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jgrapht.graph.DefaultEdge;

public class CycleHandler {
    private final Log logger = LogFactory.getLog(this.getClass());
    Wikipedia wiki;
    CategoryGraph categoryGraph;
    private Map<Integer, Color> colorMap;

    public CycleHandler(Wikipedia wiki, CategoryGraph categoryGraph) {
        this.wiki = wiki;
        this.categoryGraph = categoryGraph;
    }

    public boolean containsCycle() throws WikiApiException {
        DefaultEdge edge = this.findCycle();
        if (edge != null) {
            Category sourceCat = this.wiki.getCategory((Integer)this.categoryGraph.getGraph().getEdgeSource((Object)edge));
            Category targetCat = this.wiki.getCategory((Integer)this.categoryGraph.getGraph().getEdgeTarget((Object)edge));
            this.logger.info((Object)("Cycle: " + sourceCat.getTitle() + " - " + targetCat.getTitle()));
            return true;
        }
        return false;
    }

    public void removeCycles() throws WikiApiException {
        DefaultEdge edge = null;
        while ((edge = this.findCycle()) != null) {
            Category sourceCat = this.wiki.getCategory((Integer)this.categoryGraph.getGraph().getEdgeSource((Object)edge));
            Category targetCat = this.wiki.getCategory((Integer)this.categoryGraph.getGraph().getEdgeTarget((Object)edge));
            this.logger.info((Object)("Removing cycle: " + sourceCat.getTitle() + " - " + targetCat.getTitle()));
            this.categoryGraph.getGraph().removeEdge((Object)edge);
        }
    }

    private DefaultEdge findCycle() {
        int node;
        this.colorMap = new HashMap<Integer, Color>();
        Iterator i$ = this.categoryGraph.getGraph().vertexSet().iterator();
        while (i$.hasNext()) {
            node = (Integer)i$.next();
            this.colorMap.put(node, Color.white);
        }
        i$ = this.categoryGraph.getGraph().vertexSet().iterator();
        while (i$.hasNext()) {
            DefaultEdge e;
            node = (Integer)i$.next();
            if (!this.colorMap.get(node).equals((Object)Color.white) || (e = this.visit(node)) == null) continue;
            return e;
        }
        return null;
    }

    private DefaultEdge visit(int node) {
        this.colorMap.put(node, Color.grey);
        Set outgoingEdges = this.categoryGraph.getGraph().outgoingEdgesOf((Object)node);
        for (DefaultEdge edge : outgoingEdges) {
            DefaultEdge e;
            int outNode = (Integer)this.categoryGraph.getGraph().getEdgeTarget((Object)edge);
            if (this.colorMap.get(outNode).equals((Object)Color.grey)) {
                return edge;
            }
            if (!this.colorMap.get(outNode).equals((Object)Color.white) || (e = this.visit(outNode)) == null) continue;
            return e;
        }
        this.colorMap.put(node, Color.black);
        return null;
    }

    private static enum Color {
        white,
        grey,
        black;

    }
}

