/*
 * Decompiled with CFR 0.152.
 */
package de.tudarmstadt.ukp.wikipedia.api;

import de.tudarmstadt.ukp.wikipedia.api.CategoryGraph;
import de.tudarmstadt.ukp.wikipedia.api.Wikipedia;
import de.tudarmstadt.ukp.wikipedia.api.exception.WikiApiException;
import de.tudarmstadt.ukp.wikipedia.api.util.GraphSerialization;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class CategoryGraphManager {
    private static final Log logger = LogFactory.getLog(CategoryGraphManager.class);
    private static Map<String, CategoryGraph> catGraphMap;
    private static final String catGraphSerializationFilename = "catGraphSer";

    public static CategoryGraph getCategoryGraph(Wikipedia wiki) throws WikiApiException {
        return CategoryGraphManager.getCategoryGraph(wiki, null, true);
    }

    public static CategoryGraph getCategoryGraph(Wikipedia wiki, boolean serialize) throws WikiApiException {
        return CategoryGraphManager.getCategoryGraph(wiki, null, serialize);
    }

    public static CategoryGraph getCategoryGraph(Wikipedia wiki, Set<Integer> pageIds) throws WikiApiException {
        return CategoryGraphManager.getCategoryGraph(wiki, pageIds, true);
    }

    public static CategoryGraph getCategoryGraph(Wikipedia wiki, Set<Integer> pageIds, boolean serialize) throws WikiApiException {
        CategoryGraph catGraph;
        String wikiID;
        if (catGraphMap == null) {
            catGraphMap = new HashMap<String, CategoryGraph>();
        }
        if (catGraphMap.containsKey(wikiID = wiki.getWikipediaId())) {
            return catGraphMap.get(wikiID);
        }
        String size = "";
        if (pageIds != null) {
            size = new Integer(pageIds.size()).toString();
        }
        if (serialize && (catGraph = CategoryGraphManager.tryToLoadCategoryGraph(wiki, wikiID, size)) != null) {
            catGraphMap.put(wikiID, catGraph);
            return catGraph;
        }
        catGraph = pageIds != null ? new CategoryGraph(wiki, pageIds) : new CategoryGraph(wiki);
        catGraphMap.put(wikiID, catGraph);
        if (serialize) {
            CategoryGraphManager.saveCategoryGraph(catGraph, wikiID, size);
        }
        return catGraph;
    }

    private static CategoryGraph tryToLoadCategoryGraph(Wikipedia wiki, String wikiId, String size) throws WikiApiException {
        String defaultSerializedGraphLocation = CategoryGraphManager.getCategoryGraphSerializationFileName(wikiId, size);
        File defaulSerializedGraphFile = new File(defaultSerializedGraphLocation);
        if (defaulSerializedGraphFile.exists()) {
            try {
                logger.info((Object)("Loading category graph from " + defaultSerializedGraphLocation));
                return new CategoryGraph(wiki, GraphSerialization.loadGraph(defaultSerializedGraphLocation));
            }
            catch (IOException e) {
                throw new WikiApiException(e);
            }
            catch (ClassNotFoundException e) {
                throw new WikiApiException(e);
            }
        }
        return null;
    }

    private static void saveCategoryGraph(CategoryGraph catGraph, String wikiId, String size) throws WikiApiException {
        String defaultSerializedGraphLocation = CategoryGraphManager.getCategoryGraphSerializationFileName(wikiId, size);
        try {
            logger.info((Object)("Saving category graph to " + defaultSerializedGraphLocation));
            GraphSerialization.saveGraph(catGraph.getGraph(), defaultSerializedGraphLocation);
        }
        catch (IOException e) {
            throw new WikiApiException(e);
        }
    }

    private static String getCategoryGraphSerializationFileName(String wikiId, String size) {
        return "catGraphSer_" + wikiId + size;
    }
}

