package de.tu.darmstadt.lt.ner.util

import grizzled.slf4j.Logging

import java.io.File
import java.util.function.{Function => JavaFunction}
import java.net.URI
import java.util.concurrent.locks.{Lock, ReentrantLock}
import resource._

import java.util.concurrent.{Callable, Semaphore}

/**
  * Created by Markus Ackermann.
  * No rights reserved.
  */
object ModelLocking extends Logging {

  lazy val modelLocks = loadingCache { canonicalPathURI: URI => new Semaphore(1) }

  def performWithModelLock[T](modelDirectory: File, work: Callable[T]) = {

    val lockKey = modelDirectory.getCanonicalFile.toURI


    managed(modelLocks.get(lockKey)).acquireAndGet { _ =>

      debug(s"lock for '$lockKey' acquired")
      work.call()
      debug(s"callable under lock '$lockKey' finshed")
    }

    debug(s"lock for '$lockKey' released")
  }
}
