package de.tu.darmstadt.lt.ner.feature.extractor

import org.cleartk.ml.Feature
import org.cleartk.ml.feature.function.FeatureFunction

import org.scalactic.Requirements._
import org.scalactic.Snapshots._
import org.scalactic.TypeCheckedTripleEquals._


import scala.collection.convert.decorateAll._
import scala.collection.convert.wrapAll._

import java.util.ServiceLoader


/**
  * Created by Markus Ackermann.
  * No rights reserved.
  */
case class InjectedFeatureExtractor(featureName: String) extends FeatureFunction {

  lazy val injectedImplementation = {

    ServiceLoader.load(classOf[InjectedFeatureExtractorImplementation]).find(_.featureName === featureName)
  }

  override def apply(input: Feature) = injectedImplementation match {

    case Some(implementation) => implementation.apply(input)

    case None => sys.error(s"Unable to locate implementation provider for feature '$featureName' in class path")
  }
}

trait InjectedFeatureExtractorImplementation extends FeatureFunction {

  def featureName: String
}
