/*
 * Decompiled with CFR 0.152.
 */
package org.cleartk.ml;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.uima.UimaContext;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.fit.component.JCasAnnotator_ImplBase;
import org.apache.uima.fit.descriptor.ConfigurationParameter;
import org.apache.uima.fit.descriptor.ResourceMetaData;
import org.apache.uima.fit.factory.initializable.Initializable;
import org.apache.uima.fit.factory.initializable.InitializableFactory;
import org.apache.uima.fit.internal.EnhancedClassFile;
import org.apache.uima.resource.ResourceInitializationException;
import org.cleartk.ml.CleartkProcessingException;
import org.cleartk.ml.Feature;
import org.cleartk.ml.Instance;
import org.cleartk.ml.SequenceClassifier;
import org.cleartk.ml.SequenceClassifierFactory;
import org.cleartk.ml.SequenceDataWriter;
import org.cleartk.ml.SequenceDataWriterFactory;
import org.cleartk.util.CleartkInitializationException;
import org.cleartk.util.ReflectionUtil;

@ResourceMetaData(name="org.cleartk.ml.CleartkSequenceAnnotator", description="<br>\nCopyright (c) 2009-2011, Regents of the University of Colorado <br>\nAll rights reserved.\n<p>", version="0.2.0-2f18f8006ef564cdf2181c7754368976fefa3d94", vendor="DKPro Core Project", copyright="Copyright 2010\n\t\t\t\t\t\t\tUbiquitous Knowledge Processing\t(UKP) Lab\n\t\t\t\t\t\t\tTechnische Universit\u00e4t Darmstadt")
@EnhancedClassFile
public abstract class CleartkSequenceAnnotator<OUTCOME_TYPE>
extends JCasAnnotator_ImplBase
implements Initializable {
    public static final String PARAM_CLASSIFIER_FACTORY_CLASS_NAME = "classifierFactoryClassName";
    private static final String DEFAULT_CLASSIFIER_FACTORY_CLASS_NAME = "org.cleartk.ml.jar.SequenceJarClassifierFactory";
    @ConfigurationParameter(name="classifierFactoryClassName", mandatory=false, description="provides the full name of the SequenceClassifierFactory class to be used.", defaultValue={"org.cleartk.ml.jar.SequenceJarClassifierFactory"})
    private String classifierFactoryClassName;
    public static final String PARAM_DATA_WRITER_FACTORY_CLASS_NAME = "dataWriterFactoryClassName";
    private static final String DEFAULT_DATA_WRITER_FACTORY_CLASS_NAME = "org.cleartk.ml.jar.DefaultSequenceDataWriterFactory";
    @ConfigurationParameter(name="dataWriterFactoryClassName", mandatory=false, description="provides the full name of the SequenceDataWriterFactory class to be used.", defaultValue={"org.cleartk.ml.jar.DefaultSequenceDataWriterFactory"})
    private String dataWriterFactoryClassName;
    public static final String PARAM_IS_TRAINING = "isTraining";
    @ConfigurationParameter(name="isTraining", mandatory=false, description="determines whether this annotator is writing training data or using a classifier to annotate. Normally inferred automatically based on whether or not a DataWriterFactory class has been set.")
    private Boolean isTraining;
    private boolean primitiveIsTraining;
    protected SequenceDataWriter<OUTCOME_TYPE> dataWriter;
    protected SequenceClassifier<OUTCOME_TYPE> classifier;

    public void initialize(UimaContext context) throws ResourceInitializationException {
        super.initialize(context);
        if (this.dataWriterFactoryClassName == null && this.classifierFactoryClassName == null) {
            CleartkInitializationException.neitherParameterSet((String)PARAM_DATA_WRITER_FACTORY_CLASS_NAME, (Object)this.dataWriterFactoryClassName, (String)PARAM_CLASSIFIER_FACTORY_CLASS_NAME, (Object)this.classifierFactoryClassName);
        }
        if (this.isTraining != null) {
            this.primitiveIsTraining = this.isTraining;
        } else if (!DEFAULT_DATA_WRITER_FACTORY_CLASS_NAME.equals(this.dataWriterFactoryClassName)) {
            this.primitiveIsTraining = true;
        } else if (context.getConfigParameterValue("outputDirectory") != null) {
            this.primitiveIsTraining = true;
        } else if (!DEFAULT_CLASSIFIER_FACTORY_CLASS_NAME.equals(this.classifierFactoryClassName)) {
            this.primitiveIsTraining = false;
        } else if (context.getConfigParameterValue("classifierJarPath") != null) {
            this.primitiveIsTraining = false;
        } else {
            String message = "Please specify PARAM_IS_TRAINING - unable to infer it from context";
            throw new IllegalArgumentException(message);
        }
        if (this.isTraining()) {
            SequenceDataWriter untypedDataWriter;
            SequenceDataWriterFactory factory = (SequenceDataWriterFactory)InitializableFactory.create((UimaContext)context, (String)this.dataWriterFactoryClassName, SequenceDataWriterFactory.class);
            try {
                untypedDataWriter = factory.createDataWriter();
            }
            catch (IOException e) {
                throw new ResourceInitializationException((Throwable)e);
            }
            InitializableFactory.initialize((Object)untypedDataWriter, (UimaContext)context);
            this.dataWriter = (SequenceDataWriter)ReflectionUtil.uncheckedCast((Object)untypedDataWriter);
        } else {
            SequenceClassifier untypedClassifier;
            SequenceClassifierFactory factory = (SequenceClassifierFactory)InitializableFactory.create((UimaContext)context, (String)this.classifierFactoryClassName, SequenceClassifierFactory.class);
            try {
                untypedClassifier = factory.createClassifier();
            }
            catch (IOException e) {
                throw new ResourceInitializationException((Throwable)e);
            }
            this.classifier = (SequenceClassifier)ReflectionUtil.uncheckedCast((Object)untypedClassifier);
            ReflectionUtil.checkTypeParameterIsAssignable(CleartkSequenceAnnotator.class, (String)"OUTCOME_TYPE", (Object)((Object)this), SequenceClassifier.class, (String)"OUTCOME_TYPE", this.classifier);
            InitializableFactory.initialize((Object)untypedClassifier, (UimaContext)context);
        }
    }

    public void collectionProcessComplete() throws AnalysisEngineProcessException {
        super.collectionProcessComplete();
        if (this.isTraining()) {
            this.dataWriter.finish();
        }
    }

    protected boolean isTraining() {
        return this.primitiveIsTraining;
    }

    protected List<OUTCOME_TYPE> classify(List<Instance<OUTCOME_TYPE>> instances) throws CleartkProcessingException {
        ArrayList<List<Feature>> instanceFeatures = new ArrayList<List<Feature>>();
        for (Instance<OUTCOME_TYPE> instance : instances) {
            instanceFeatures.add(instance.getFeatures());
        }
        return this.classifier.classify(instanceFeatures);
    }

    protected List<OUTCOME_TYPE> classify(Map<Integer, List<Instance<OUTCOME_TYPE>>> instances, File featureFile) throws CleartkProcessingException {
        LinkedHashMap<Integer, List<List<Feature>>> instanceFeaturesMap = new LinkedHashMap<Integer, List<List<Feature>>>();
        for (int i : instances.keySet()) {
            ArrayList<List> instanceFeatures = new ArrayList<List>();
            for (Instance<OUTCOME_TYPE> instance : instances.get(i)) {
                instanceFeatures.add(instance.getFeatures());
            }
            instanceFeaturesMap.put(i, instanceFeatures);
        }
        return this.classifier.classify(instanceFeaturesMap, featureFile);
    }
}

