/*
 * Decompiled with CFR 0.152.
 */
package de.tu.darmstadt.lt.ner.writer;

import de.tudarmstadt.ukp.dkpro.core.api.segmentation.type.Sentence;
import de.tudarmstadt.ukp.dkpro.core.api.segmentation.type.Token;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.fit.component.JCasConsumer_ImplBase;
import org.apache.uima.fit.descriptor.ConfigurationParameter;
import org.apache.uima.fit.descriptor.ResourceMetaData;
import org.apache.uima.fit.internal.EnhancedClassFile;
import org.apache.uima.fit.util.JCasUtil;
import org.apache.uima.jcas.JCas;

@ResourceMetaData(name="de.tu.darmstadt.lt.ner.writer.SentenceToCRFTestFileWriter", description="This is a helper Class, can be used from NoD. If you use a DKPro tokenizer during training, this\nmethod use the same tokenizer available in DKPro,", version="0.2.0-2f18f8006ef564cdf2181c7754368976fefa3d94", vendor="DKPro Core Project", copyright="Copyright 2010\n\t\t\t\t\t\t\tUbiquitous Knowledge Processing\t(UKP) Lab\n\t\t\t\t\t\t\tTechnische Universit\u00e4t Darmstadt")
@EnhancedClassFile
public class SentenceToCRFTestFileWriter
extends JCasConsumer_ImplBase {
    public static final String SENTENCE_ITERATOR = "iterator";
    @ConfigurationParameter(name="iterator", mandatory=true)
    private List<String> sentences = null;
    public static final String CRF_TEST_FILE_NAME = "crfFileName";
    @ConfigurationParameter(name="crfFileName", mandatory=true)
    private String crfFileName = null;
    public static final String CRF_TEST_FILE_LANG = "crfTestFileLanguage";
    @ConfigurationParameter(name="crfTestFileLanguage", mandatory=false)
    private String crfTestFileLanguage = "de";
    public static final String LF = System.getProperty("line.separator");

    public void process(JCas jcas) throws AnalysisEngineProcessException {
        try {
            StringBuilder sb = new StringBuilder();
            int index = 0;
            for (String l : this.sentences) {
                Sentence sentence = new Sentence(jcas, index, l.length() + index);
                sentence.addToIndexes();
                index = index + l.length() + 1;
                sb.append(l + "\n");
            }
            jcas.setDocumentText(sb.toString().trim());
            StringBuilder sbCRF = new StringBuilder();
            Map sentencesTokens = JCasUtil.indexCovered((JCas)jcas, Sentence.class, Token.class);
            ArrayList sentences = new ArrayList(sentencesTokens.keySet());
            Collections.sort(sentences, new Comparator<Sentence>(){

                @Override
                public int compare(Sentence arg0, Sentence arg1) {
                    return arg0.getBegin() - arg1.getBegin();
                }
            });
            for (Sentence sentence : sentences) {
                for (Token token : (Collection)sentencesTokens.get(sentence)) {
                    sbCRF.append(token.getCoveredText() + LF);
                }
                sbCRF.append(LF);
            }
            IOUtils.write((String)sbCRF.toString(), (OutputStream)new FileOutputStream(this.crfFileName), (String)"UTF-8");
        }
        catch (Exception e) {
            System.out.println(e);
        }
    }
}

