/*
 * Decompiled with CFR 0.152.
 */
package de.tu.darmstadt.lt.ner.writer;

import de.tu.darmstadt.lt.ner.types.GoldNamedEntity;
import de.tudarmstadt.ukp.dkpro.core.api.ner.type.NamedEntity;
import de.tudarmstadt.ukp.dkpro.core.api.segmentation.type.Sentence;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.cas.text.AnnotationFS;
import org.apache.uima.fit.component.JCasConsumer_ImplBase;
import org.apache.uima.fit.descriptor.ConfigurationParameter;
import org.apache.uima.fit.descriptor.ResourceMetaData;
import org.apache.uima.fit.internal.EnhancedClassFile;
import org.apache.uima.fit.util.JCasUtil;
import org.apache.uima.jcas.JCas;
import org.apache.uima.util.Level;

@ResourceMetaData(name="de.tu.darmstadt.lt.ner.writer.EvaluatedNERWriter", description="Copyright 2014\r\nFG Language Technology\r\nTechnische Universit\u00e4t Darmstadt\r\n\r\nLicensed under the Apache License, Version 2.0 (the \"License\");\r\nyou may not use this file except in compliance with the License.\r\nYou may obtain a copy of the License at\r\n\r\n http://www.apache.org/licenses/LICENSE-2.0\r\n\r\nUnless required by applicable law or agreed to in writing, software\r\ndistributed under the License is distributed on an \"AS IS\" BASIS,\r\nWITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\r\nSee the License for the specific language governing permissions and\r\nlimitations under the License.", version="0.2.0-2f18f8006ef564cdf2181c7754368976fefa3d94", vendor="DKPro Core Project", copyright="Copyright 2010\n\t\t\t\t\t\t\tUbiquitous Knowledge Processing\t(UKP) Lab\n\t\t\t\t\t\t\tTechnische Universit\u00e4t Darmstadt")
@EnhancedClassFile
public class EvaluatedNERWriter
extends JCasConsumer_ImplBase {
    public static final String OUTPUT_FILE = "OutputFile";
    @ConfigurationParameter(name="OutputFile", mandatory=true)
    private File OutputFile = null;
    public static final String NOD_OUTPUT_FILE = "nodOutputFile";
    @ConfigurationParameter(name="nodOutputFile", mandatory=false)
    private File nodOutputFile = null;
    public static final String IS_GOLD = "isGold";
    @ConfigurationParameter(name="isGold", mandatory=false)
    private boolean isGold = false;
    public static final String SENTENCES_ID = "sentencesId";
    @ConfigurationParameter(name="sentencesId", mandatory=false)
    private List<String> sentencesId = null;
    public static final String LF = System.getProperty("line.separator");
    public static final String TAB = "\t";
    private static final String ORG = "ORG";
    private static final String PER = "PER";
    private static final String B_ORG = "B-ORG";
    private static final String B_PER = "B-PER";
    private static final String I_ORG = "I-ORG";
    private static final String I_PER = "I-PER";
    private static final String TYPE_SEP = "$";
    private static final String ENT_SEP = ",";

    public void process(JCas jCas) throws AnalysisEngineProcessException {
        try {
            FileWriter outputWriter = new FileWriter(this.OutputFile);
            Map sentencesNER = JCasUtil.indexCovered((JCas)jCas, Sentence.class, NamedEntity.class);
            FileWriter nodOutputWriter = null;
            if (this.nodOutputFile != null) {
                nodOutputWriter = new FileWriter(this.nodOutputFile);
            }
            int sentenceIndex = 0;
            ArrayList sentences = new ArrayList(sentencesNER.keySet());
            Collections.sort(sentences, new Comparator<Sentence>(){

                @Override
                public int compare(Sentence arg0, Sentence arg1) {
                    return arg0.getBegin() - arg1.getBegin();
                }
            });
            for (Sentence sentence : sentences) {
                ArrayList<String> personSb = new ArrayList<String>();
                ArrayList<String> orgSb = new ArrayList<String>();
                String prevNeType = "O";
                String namedEntity = "";
                for (NamedEntity neAnnotation : (Collection)sentencesNER.get(sentence)) {
                    String text = neAnnotation.getCoveredText().replace(" ", "");
                    String neType = neAnnotation.getValue();
                    StringBuilder sb = new StringBuilder();
                    sb.append(text);
                    sb.append(" ");
                    if (this.isGold) {
                        sb.append(((GoldNamedEntity)((Object)JCasUtil.selectCovered((JCas)jCas, GoldNamedEntity.class, (AnnotationFS)neAnnotation).get(0))).getNamedEntityType());
                    }
                    sb.append(" ");
                    sb.append(neAnnotation.getValue());
                    sb.append(LF);
                    outputWriter.write(sb.toString());
                    if (this.nodOutputFile == null) continue;
                    if (neType.equals("O")) {
                        if (prevNeType == "O") continue;
                        if (prevNeType.equals(PER)) {
                            personSb.add(namedEntity);
                            prevNeType = "O";
                            namedEntity = "";
                            continue;
                        }
                        orgSb.add(namedEntity.trim());
                        prevNeType = "O";
                        namedEntity = "";
                        continue;
                    }
                    if (prevNeType.equals(ORG) && (neType.equals(B_PER) || neType.equals(I_PER))) {
                        orgSb.add(namedEntity.trim());
                        prevNeType = PER;
                        namedEntity = text;
                        continue;
                    }
                    if (prevNeType.equals(PER) && (neType.equals(B_ORG) || neType.equals(I_ORG))) {
                        personSb.add(namedEntity);
                        prevNeType = ORG;
                        namedEntity = text;
                        continue;
                    }
                    if (neType.equals(B_PER) || neType.equals(I_PER)) {
                        prevNeType = PER;
                        namedEntity = namedEntity.trim() + " " + text;
                        continue;
                    }
                    if (neType.equals(B_ORG) || neType.equals(I_ORG)) {
                        prevNeType = ORG;
                        namedEntity = namedEntity.trim() + " " + text;
                        continue;
                    }
                    prevNeType = "O";
                }
                outputWriter.write(LF);
                if (this.nodOutputFile != null && this.sentencesId != null) {
                    nodOutputWriter.write(this.sentencesId.get(sentenceIndex) + TAB + (personSb.size() == 0 ? "O" : this.listNames(personSb)) + TAB + TYPE_SEP + TAB + (orgSb.size() == 0 ? "O" : this.listNames(orgSb)) + LF);
                }
                ++sentenceIndex;
            }
            outputWriter.close();
            if (nodOutputWriter != null) {
                nodOutputWriter.close();
            }
            this.getContext().getLogger().log(Level.INFO, "Output written to: " + this.OutputFile.getAbsolutePath());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private String listNames(List<String> aNameLists) {
        return StringUtils.join(aNameLists, (String)ENT_SEP).replace("'", "");
    }
}

