/*
 * Decompiled with CFR 0.152.
 */
package de.tu.darmstadt.lt.ner.util;

import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Properties;

public class Configuration {
    private final Properties properties = new Properties();

    public Configuration(String sourceURL) {
        try (InputStream configInput = new URL(sourceURL).openStream();){
            this.properties.load(configInput);
        }
    }

    public void writeTo(Path file) {
        try (OutputStream output = Files.newOutputStream(file, new OpenOption[0]);){
            this.properties.store(output, "");
        }
    }

    public boolean usePosition() {
        return this.properties.getProperty("usePosition", "0").equals("1");
    }

    public boolean useFreeBase() {
        return this.properties.getProperty("useFreeBase", "0").equals("1");
    }

    public boolean useClarkPosInduction() {
        return this.properties.getProperty("useClarkPosInduction", "0").equals("1");
    }

    public Properties getProperties() {
        return this.properties;
    }
}

