/*
 * Decompiled with CFR 0.152.
 */
package de.tu.darmstadt.lt.ner.preprocessing;

import de.tu.darmstadt.lt.ner.annotator.NERAnnotator;
import de.tu.darmstadt.lt.ner.preprocessing.ChangeColon;
import de.tu.darmstadt.lt.ner.reader.NERLookupCaching;
import de.tu.darmstadt.lt.ner.reader.NERReader;
import de.tu.darmstadt.lt.ner.util.Configuration;
import de.tu.darmstadt.lt.ner.writer.EvaluatedNERWriter;
import de.tu.darmstadt.lt.ner.writer.SentenceToCRFTestFileWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import org.apache.commons.io.IOUtils;
import org.apache.uima.UIMAException;
import org.apache.uima.UIMAFramework;
import org.apache.uima.analysis_engine.AnalysisEngine;
import org.apache.uima.collection.CollectionReader;
import org.apache.uima.fit.factory.AnalysisEngineFactory;
import org.apache.uima.fit.factory.JCasFactory;
import org.apache.uima.fit.pipeline.SimplePipeline;
import org.apache.uima.jcas.JCas;
import org.apache.uima.util.Level;
import org.cleartk.ml.crfsuite.CrfSuiteStringOutcomeDataWriter;
import org.cleartk.ml.jar.Train;
import org.cleartk.util.cr.FilesCollectionReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GermaNERMain {
    private static final Logger log = LoggerFactory.getLogger(GermaNERMain.class);
    private String modelDirString;
    private File modelDirectory;
    private String testFileName;
    private String trainFileName;
    private String dataZipFile;
    URL configSource = null;
    private final AtomicReference<Object> mode = new AtomicReference();
    private final AtomicReference<Object> dataZipURL = new AtomicReference();
    private final AtomicReference<Object> configuration = new AtomicReference();
    private static final ChangeColon changeColon = new ChangeColon();
    private static final String USAGE = "USAGE: java -jar germanner.jar [-c config.properties] \n [-f trainingFileName] -t testFileName -d modelOutputDirectory -o outputFile -r data.zip file containing files used for different features";

    public void trainModel(File NER_TagFile) throws UIMAException, IOException {
        this.prepareLookupCaching();
        this.trainUnderLocking(NER_TagFile);
    }

    private boolean trainUnderLocking(File NER_TagFile) {
        System.out.println("Start model generation");
        SimplePipeline.runPipeline((CollectionReader)FilesCollectionReader.getCollectionReaderWithSuffixes((String)NER_TagFile.getAbsolutePath(), (String)"ConnlView", (String[])new String[]{NER_TagFile.getName()}), (AnalysisEngine[])new AnalysisEngine[]{AnalysisEngineFactory.createEngine(NERReader.class, (Object[])new Object[]{"DataZipURL", this.getDataZipURL(), "configuration", this.configSource.toExternalForm()}), AnalysisEngineFactory.createEngine(NERAnnotator.class, (Object[])new Object[]{"configuration", this.configSource.toExternalForm(), "FeatureExtractionFile", this.modelDirectory.getAbsolutePath() + "/feature.xml", "isTraining", true, "outputDirectory", this.modelDirectory.getAbsolutePath(), "dataWriterClassName", CrfSuiteStringOutcomeDataWriter.class})});
        this.getConfiguration().writeTo(this.modelDirectory.toPath().resolve("config.properties"));
        System.out.println("Model generation done");
        System.out.println("Start training");
        Train.main((String[])new String[]{this.modelDirectory.getAbsolutePath()});
        System.out.println("Training done");
        return true;
    }

    public void classifyTestFile(File testPosFile, File outputFile, File aNodeResultFile, List<Integer> aSentencesIds) throws UIMAException, IOException {
        this.prepareLookupCaching();
        Path savedConfigFile = this.modelDirectory.toPath().resolve("config.properties");
        URL testConfigSource = Files.isRegularFile(savedConfigFile, new LinkOption[0]) ? savedConfigFile.normalize().toUri().toURL() : this.configSource;
        String normalizedTestFilePath = testPosFile.getPath() + ".normalized";
        File normalizedOutputFile = this.predictionsTempFile(outputFile);
        changeColon.normalize(testPosFile.getPath(), normalizedTestFilePath);
        log.debug("using config to classification from: " + testConfigSource);
        this.classifyUnderLocking(testPosFile, normalizedOutputFile, testConfigSource, aNodeResultFile, aSentencesIds);
        changeColon.deNormalize(normalizedOutputFile.getPath(), outputFile.getPath());
        normalizedOutputFile.delete();
    }

    private boolean classifyUnderLocking(File testPosFile, File outputFile, URL testConfigSource, File aNodeResultFile, List<Integer> aSentencesIds) {
        System.out.println("Start tagging");
        SimplePipeline.runPipeline((CollectionReader)FilesCollectionReader.getCollectionReaderWithSuffixes((String)testPosFile.getAbsolutePath(), (String)"ConnlView", (String[])new String[]{testPosFile.getName()}), (AnalysisEngine[])new AnalysisEngine[]{AnalysisEngineFactory.createEngine(NERReader.class, (Object[])new Object[]{"DataZipURL", this.getDataZipURL(), "configuration", testConfigSource.toExternalForm()}), AnalysisEngineFactory.createEngine(NERAnnotator.class, (Object[])new Object[]{"configuration", testConfigSource.toExternalForm(), "FeatureExtractionFile", this.modelDirectory.getAbsolutePath() + "/feature.xml", "ModelLocation", this.modelDirectory.getAbsolutePath(), "PredictionOutputPath", outputFile, "classifierJarPath", this.modelDirectory.getAbsolutePath() + "/model.jar"}), AnalysisEngineFactory.createEngine(EvaluatedNERWriter.class, (Object[])new Object[]{"OutputFile", outputFile, "isGold", false, "nodOutputFile", aNodeResultFile, "sentencesId", aSentencesIds})});
        System.out.println("Tagging done");
        return true;
    }

    public static void sentenceToCRFFormat(List<String> sentences, String aCRFFileName, String aLanguage) throws UIMAException, IllegalArgumentException, IOException {
        SimplePipeline.runPipeline((JCas)JCasFactory.createJCas(), (AnalysisEngine[])new AnalysisEngine[]{AnalysisEngineFactory.createEngine(SentenceToCRFTestFileWriter.class, (Object[])new Object[]{"iterator", sentences, "crfFileName", aCRFFileName, "crfTestFileLanguage", aLanguage})});
    }

    public static void main(String[] args) throws Exception {
        long startTime = System.currentTimeMillis();
        long start = System.currentTimeMillis();
        GermaNERMain main = new GermaNERMain();
        AtomicReference<Object> configuration = main.configuration;
        List<String> argList = Arrays.asList(args);
        try {
            if (argList.contains("-r") && argList.get(argList.indexOf("-r") + 1) != null && new File(argList.get(argList.indexOf("-r") + 1)).exists()) {
                main.dataZipFile = argList.get(argList.indexOf("-r") + 1);
            }
            if (argList.contains("-c") && argList.get(argList.indexOf("-c") + 1) != null && new File(argList.get(argList.indexOf("-c") + 1)).isFile()) {
                main.configSource = Paths.get(argList.get(argList.indexOf("-c") + 1), new String[0]).toUri().toURL();
            } else {
                log.error("Default configuration is read from the system\n");
                main.configSource = ClassLoader.getSystemResource("config.properties");
            }
            if (argList.contains("-t") && argList.get(argList.indexOf("-t") + 1) != null) {
                if (!new File(argList.get(argList.indexOf("-t") + 1)).exists()) {
                    log.error("There is no test file to tag");
                    System.exit(1);
                }
                main.testFileName = argList.get(argList.indexOf("-t") + 1);
            }
            if (argList.contains("-f") && argList.get(argList.indexOf("-f") + 1) != null) {
                if (!new File(argList.get(argList.indexOf("-f") + 1)).exists()) {
                    log.error("The system is running in tagging mode. No training data provided");
                } else {
                    main.trainFileName = argList.get(argList.indexOf("-f") + 1);
                }
            }
            if (argList.contains("-d") && argList.get(argList.indexOf("-d") + 1) != null) {
                if (new File(argList.get(argList.indexOf("-d") + 1)).exists()) {
                    main.modelDirString = argList.get(argList.indexOf("-d") + 1);
                } else {
                    File dir = new File(argList.get(argList.indexOf("-d") + 1));
                    dir.mkdirs();
                    main.modelDirString = dir.getAbsolutePath();
                }
            }
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        try {
            main.prepareModelDir(false);
            File outputFile = null;
            if (argList.contains("-o") && argList.get(argList.indexOf("-o") + 1) != null) {
                outputFile = new File(argList.get(argList.indexOf("-o") + 1));
            } else {
                log.error("The directory for this output file does not exist. Output file will be found in the current directory under folder \"output\"");
                outputFile = new File(main.modelDirectory, "result.tsv");
            }
            if (main.getMode().equals("f") && main.trainFileName != null) {
                changeColon.normalize(main.trainFileName, main.trainFileName + ".normalized");
                main.trainModel(new File(main.trainFileName + ".normalized"));
            } else if (main.getMode().equals("ft") && main.trainFileName != null && main.testFileName != null) {
                changeColon.normalize(main.trainFileName, main.trainFileName + ".normalized");
                changeColon.normalize(main.testFileName, main.testFileName + ".normalized");
                main.trainModel(new File(main.trainFileName + ".normalized"));
                main.classifyTestFile(new File(main.testFileName + ".normalized"), outputFile, null, null);
            } else {
                changeColon.normalize(main.testFileName, main.testFileName + ".normalized");
                main.classifyTestFile(new File(main.testFileName + ".normalized"), outputFile, null, null);
            }
            long now = System.currentTimeMillis();
            UIMAFramework.getLogger().log(Level.INFO, "Time: " + (now - start) + "ms");
        }
        catch (Exception e) {
            throw new RuntimeException("error in GermaNER run:\n" + argList.stream().collect(Collectors.joining(" ")), e);
        }
        long endTime = System.currentTimeMillis();
        long totalTime = endTime - startTime;
        System.out.println("NER train/test done in " + totalTime / 1000L + " seconds");
    }

    private void prepareModelDir(boolean copyFiles) throws IOException, FileNotFoundException {
        this.modelDirectory = this.modelDirString == null || this.modelDirString.isEmpty() ? new File("output") : new File(this.modelDirString);
        this.modelDirectory.mkdirs();
        if (copyFiles) {
            if (!new File(this.modelDirectory, "model.jar").exists()) {
                IOUtils.copyLarge((InputStream)ClassLoader.getSystemResourceAsStream("model/model.jar"), (OutputStream)new FileOutputStream(new File(this.modelDirectory, "model.jar")));
            }
            if (!new File(this.modelDirectory, "MANIFEST.MF").exists()) {
                IOUtils.copyLarge((InputStream)ClassLoader.getSystemResourceAsStream("model/MANIFEST.MF"), (OutputStream)new FileOutputStream(new File(this.modelDirectory, "MANIFEST.MF")));
            }
            if (!new File(this.modelDirectory, "config.properties").exists()) {
                IOUtils.copyLarge((InputStream)ClassLoader.getSystemResourceAsStream("config.properties"), (OutputStream)new FileOutputStream(new File(this.modelDirectory, "config.properties")));
            }
            if (!new File(this.modelDirectory, "feature.xml").exists()) {
                IOUtils.copyLarge((InputStream)ClassLoader.getSystemResourceAsStream("feature/feature.xml"), (OutputStream)new FileOutputStream(new File(this.modelDirectory, "feature.xml")));
            }
        }
    }

    private String computeMode() {
        if (this.trainFileName != null && this.testFileName != null) {
            return "ft";
        }
        if (this.trainFileName != null) {
            return "f";
        }
        if (this.testFileName != null) {
            return "t";
        }
        log.error("neither train nor prediction selected");
        log.error(USAGE);
        System.exit(1);
        return null;
    }

    private URL computeDataZipURL() {
        URL res;
        URL uRL = res = this.dataZipFile == null ? ClassLoader.getSystemResource("data.zip") : new File(this.dataZipFile).toURI().toURL();
        if (res == null) {
            throw new RuntimeException("Unable to locate data.zip");
        }
        return res;
    }

    private void prepareLookupCaching() {
        if (!NERLookupCaching.dataZipUrlSet()) {
            NERLookupCaching.setDataZipURL(this.getDataZipURL());
        }
    }

    private File predictionsTempFile(File finalPredictionsFile) {
        Optional<File> targetDirOption = Optional.ofNullable(finalPredictionsFile.getParentFile());
        targetDirOption.map(File::mkdirs);
        File parent = targetDirOption.orElseGet(() -> new File(""));
        File tmpFile = Files.createTempFile(parent.toPath(), finalPredictionsFile.getName() + ".", ".tmp", new FileAttribute[0]).toFile();
        tmpFile.deleteOnExit();
        return tmpFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getMode() {
        Object value = this.mode.get();
        if (value == null) {
            AtomicReference<Object> atomicReference = this.mode;
            synchronized (atomicReference) {
                value = this.mode.get();
                if (value == null) {
                    String actualValue = this.computeMode();
                    value = actualValue == null ? this.mode : actualValue;
                    this.mode.set(value);
                }
            }
        }
        return (String)(value == this.mode ? null : value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public URL getDataZipURL() {
        Object value = this.dataZipURL.get();
        if (value == null) {
            AtomicReference<Object> atomicReference = this.dataZipURL;
            synchronized (atomicReference) {
                value = this.dataZipURL.get();
                if (value == null) {
                    URL actualValue = this.computeDataZipURL();
                    value = actualValue == null ? this.dataZipURL : actualValue;
                    this.dataZipURL.set(value);
                }
            }
        }
        return (URL)(value == this.dataZipURL ? null : value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Configuration getConfiguration() {
        Object value = this.configuration.get();
        if (value == null) {
            AtomicReference<Object> atomicReference = this.configuration;
            synchronized (atomicReference) {
                value = this.configuration.get();
                if (value == null) {
                    Configuration actualValue = new Configuration(this.configSource.toExternalForm());
                    value = actualValue == null ? this.configuration : actualValue;
                    this.configuration.set(value);
                }
            }
        }
        return (Configuration)(value == this.configuration ? null : value);
    }
}

