/*
 * Decompiled with CFR 0.152.
 */
package de.tu.darmstadt.lt.ner.feature.extractor;

import java.util.Collections;
import java.util.List;
import org.cleartk.ml.Feature;
import org.cleartk.ml.feature.function.FeatureFunction;

public class LTCharacterNgramFeatureFunction
implements FeatureFunction {
    Orientation orientation;
    int start;
    int end;
    int minimumValueLength;
    boolean lowerCase;
    private String name;

    public LTCharacterNgramFeatureFunction(String featureName, Orientation orientation, int start, int end, int minimumValueLength, boolean lowerCase) {
        this.name = Feature.createName((String[])new String[]{"NGram", orientation == Orientation.RIGHT_TO_LEFT ? "Right" : "Left", String.valueOf(start), String.valueOf(end), String.valueOf(minimumValueLength), lowerCase ? "lower" : null, featureName});
        if (minimumValueLength < end) {
            throw new IllegalArgumentException("minimumValueLength must be greater than or equal to the parameter end.");
        }
        this.orientation = orientation;
        this.start = start;
        this.end = end;
        this.minimumValueLength = minimumValueLength;
        this.lowerCase = lowerCase;
    }

    public LTCharacterNgramFeatureFunction(Orientation orientation, int start, int end, int minimumValueLength, boolean lowerCase) {
        this(null, orientation, start, end, minimumValueLength, lowerCase);
    }

    public LTCharacterNgramFeatureFunction(String featureName, Orientation orientation, int start, int end) {
        this(featureName, orientation, start, end, end - start, false);
    }

    public LTCharacterNgramFeatureFunction(Orientation orientation, int start, int end) {
        this(null, orientation, start, end);
    }

    public List<Feature> apply(Feature feature) {
        String featureName = Feature.createName((String[])new String[]{this.name, feature.getName()});
        Object featureValue = feature.getValue();
        if (featureValue == null || !(featureValue instanceof String)) {
            return Collections.singletonList(new Feature(featureName, (Object)"OUT"));
        }
        String value = featureValue.toString();
        if (value == null || value.length() < this.minimumValueLength) {
            return Collections.singletonList(new Feature(featureName, (Object)"OUT"));
        }
        String ngram = this.orientation == Orientation.LEFT_TO_RIGHT ? value.substring(this.start, this.end) : value.substring(value.length() - this.end, value.length() - this.start);
        if (this.lowerCase) {
            ngram = ngram.toLowerCase();
        }
        return Collections.singletonList(new Feature(featureName, (Object)ngram));
    }

    public static enum Orientation {
        RIGHT_TO_LEFT,
        LEFT_TO_RIGHT;

    }
}

