/*
 * Decompiled with CFR 0.152.
 */
package de.tu.darmstadt.lt.ner.feature.extractor;

import java.util.Collections;
import java.util.List;
import org.cleartk.ml.Feature;
import org.cleartk.ml.feature.function.FeatureFunction;
import org.cleartk.ml.feature.util.CaseUtil;

public class LTCapitalTypeFeatureFunction
implements FeatureFunction {
    public static final String DEFAULT_NAME = "CapitalType";

    public List<Feature> apply(Feature feature) {
        String featureName = Feature.createName((String[])new String[]{DEFAULT_NAME, feature.getName()});
        Object featureValue = feature.getValue();
        if (featureValue == null) {
            return Collections.singletonList(new Feature(featureName, (Object)CapitalType.INVALID.toString()));
        }
        if (featureValue instanceof String) {
            String upperCaseValue;
            String value = featureValue.toString();
            if (value == null || value.length() == 0) {
                return Collections.singletonList(new Feature(featureName, (Object)CapitalType.INVALID.toString()));
            }
            String lowerCaseValue = value.toLowerCase();
            if (lowerCaseValue.equals(upperCaseValue = value.toUpperCase())) {
                return Collections.singletonList(new Feature(featureName, (Object)CapitalType.INVALID.toString()));
            }
            if (value.equals(value.toLowerCase())) {
                return Collections.singletonList(new Feature(featureName, (Object)CapitalType.ALL_LOWERCASE.toString()));
            }
            if (value.equals(value.toUpperCase())) {
                return Collections.singletonList(new Feature(featureName, (Object)CapitalType.ALL_UPPERCASE.toString()));
            }
            if (CaseUtil.isInitialUppercase((String)value)) {
                return Collections.singletonList(new Feature(featureName, (Object)CapitalType.INITIAL_UPPERCASE.toString()));
            }
            return Collections.singletonList(new Feature(featureName, (Object)CapitalType.MIXED_CASE.toString()));
        }
        return Collections.singletonList(new Feature(featureName, (Object)CapitalType.INVALID.toString()));
    }

    public static enum CapitalType {
        ALL_UPPERCASE,
        ALL_LOWERCASE,
        INITIAL_UPPERCASE,
        MIXED_CASE,
        INVALID;

    }
}

