/*
 * Decompiled with CFR 0.152.
 */
package de.tu.darmstadt.lt.ner.feature.extractor;

import de.tu.darmstadt.lt.ner.reader.NERLookupCaching;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.cleartk.ml.Feature;
import org.cleartk.ml.feature.function.FeatureFunction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DBPersonListFeatureExtractor
implements FeatureFunction {
    private static final Logger log = LoggerFactory.getLogger(DBPersonListFeatureExtractor.class);
    public static final String DEFAULT_NAME = "DBPersonName";

    public List<Feature> apply(Feature feature) {
        Map dbPersonNameList = (Map)NERLookupCaching.customMapCache().get((Object)DEFAULT_NAME, () -> DBPersonListFeatureExtractor.readData());
        String tokenString = feature.getValue().toString();
        String featureValue = dbPersonNameList.getOrDefault(tokenString, "O");
        return Collections.singletonList(new Feature(DEFAULT_NAME, (Object)featureValue));
    }

    private static Map<String, String> readData() {
        return NERLookupCaching.readMapDataMulti("inDBperson.txt", DEFAULT_NAME, line -> {
            String[] sep;
            HashMap<String, String> subMap = new HashMap<String, String>(4);
            for (String token : sep = line.split("\\s+")) {
                subMap.put(token, "BI");
            }
            return subMap;
        });
    }
}

