/*
 * Decompiled with CFR 0.152.
 */
package de.tu.darmstadt.lt.ner.feature.extractor;

import de.tu.darmstadt.lt.ner.reader.NERLookupCaching;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.cleartk.ml.Feature;
import org.cleartk.ml.feature.function.FeatureFunction;

public class DBLocationListFeatureExtractor
implements FeatureFunction {
    public static final String DEFAULT_NAME = "DBPLocationName";

    public List<Feature> apply(Feature feature) {
        Map dbLocationNameList = (Map)NERLookupCaching.customMapCache().get((Object)DEFAULT_NAME, () -> this.readData());
        String tokenString = feature.getValue().toString();
        String featureValue = dbLocationNameList.getOrDefault(tokenString, "O");
        return Collections.singletonList(new Feature("DBPLocation", (Object)featureValue));
    }

    private Map<String, String> readData() {
        return NERLookupCaching.readMapDataMulti("location_wiki.list", DEFAULT_NAME, line -> {
            HashMap<String, String> subMap = new HashMap<String, String>(4);
            String[] lineSplit = line.split("\\t");
            String wikiType = lineSplit[1];
            String[] multiWordSplit = lineSplit[0].split("\\s+");
            for (int i = 0; i < multiWordSplit.length; ++i) {
                if (i == 0) {
                    subMap.put(lineSplit[0], "B-" + wikiType);
                    continue;
                }
                subMap.put(lineSplit[0], "I-" + wikiType);
            }
            return subMap;
        });
    }
}

