/*
 * Decompiled with CFR 0.152.
 */
package de.tu.darmstadt.lt.ner.annotator;

import de.tu.darmstadt.lt.ner.annotator.GetFeaturesFromConfigFile;
import de.tu.darmstadt.lt.ner.types.GoldNamedEntity;
import de.tu.darmstadt.lt.ner.util.Configuration;
import de.tudarmstadt.ukp.dkpro.core.api.ner.type.NamedEntity;
import de.tudarmstadt.ukp.dkpro.core.api.segmentation.type.Sentence;
import de.tudarmstadt.ukp.dkpro.core.api.segmentation.type.Token;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.uima.UimaContext;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.cas.text.AnnotationFS;
import org.apache.uima.fit.descriptor.ConfigurationParameter;
import org.apache.uima.fit.descriptor.ResourceMetaData;
import org.apache.uima.fit.internal.EnhancedClassFile;
import org.apache.uima.fit.util.JCasUtil;
import org.apache.uima.jcas.JCas;
import org.apache.uima.jcas.tcas.Annotation;
import org.apache.uima.resource.ResourceInitializationException;
import org.cleartk.ml.CleartkProcessingException;
import org.cleartk.ml.CleartkSequenceAnnotator;
import org.cleartk.ml.Instance;
import org.cleartk.ml.feature.extractor.CleartkExtractor;
import org.cleartk.ml.feature.extractor.FeatureExtractor1;

@ResourceMetaData(name="de.tu.darmstadt.lt.ner.annotator.NERAnnotator", description="Copyright 2014\nFG Language Technology\nTechnische Universit\u00e4t Darmstadt\n\nLicensed under the Apache License, Version 2.0 (the \"License\");\nyou may not use this file except in compliance with the License.\nYou may obtain a copy of the License at\n\n http://www.apache.org/licenses/LICENSE-2.0\n\nUnless required by applicable law or agreed to in writing, software\ndistributed under the License is distributed on an \"AS IS\" BASIS,\nWITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\nSee the License for the specific language governing permissions and\nlimitations under the License.", version="0.2.0-2f18f8006ef564cdf2181c7754368976fefa3d94", vendor="DKPro Core Project", copyright="Copyright 2010\n\t\t\t\t\t\t\tUbiquitous Knowledge Processing\t(UKP) Lab\n\t\t\t\t\t\t\tTechnische Universit\u00e4t Darmstadt")
@EnhancedClassFile
public class NERAnnotator
extends CleartkSequenceAnnotator<String> {
    public static final String PARAM_CONFIGURATION = "configuration";
    @ConfigurationParameter(name="configuration")
    private Configuration configuration = null;
    public static final String PARAM_FEATURE_EXTRACTION_FILE = "FeatureExtractionFile";
    @ConfigurationParameter(name="FeatureExtractionFile", mandatory=false, description="if a feature extraction/context extractor filename is given the xml file is parsed and the\nfeatures are used, otherwise it will not be used")
    private String featureExtractionFile = null;
    public static final String PARAM_MODEL_LOCATION = "ModelLocation";
    @ConfigurationParameter(name="ModelLocation", mandatory=false)
    private String modelLocation = null;
    public static final String PARAM_PREDICTION_OUTPUT = "PredictionOutputPath";
    @ConfigurationParameter(name="PredictionOutputPath", mandatory=false)
    private File outputFile = null;
    private final AtomicReference<Object> crfsuiteOutputfile = new AtomicReference();
    private List<FeatureExtractor1<Token>> featureExtractors;

    @Override
    public void initialize(UimaContext context) throws ResourceInitializationException {
        super.initialize(context);
        this.featureExtractors = GetFeaturesFromConfigFile.getFeatures(this.configuration.getProperties());
    }

    public void process(JCas jCas) throws AnalysisEngineProcessException {
        Map sentencesTokens = JCasUtil.indexCovered((JCas)jCas, Sentence.class, Token.class);
        ArrayList sentences = new ArrayList(sentencesTokens.keySet());
        Collections.sort(sentences, new Comparator<Sentence>(){

            @Override
            public int compare(Sentence arg0, Sentence arg1) {
                return arg0.getBegin() - arg1.getBegin();
            }
        });
        LinkedHashMap<Integer, List<Instance<String>>> sentencesInstances = new LinkedHashMap<Integer, List<Instance<String>>>();
        ArrayList<Sentence> sentenceList = new ArrayList<Sentence>();
        int index = 0;
        int it = 1;
        for (Sentence sentence : sentences) {
            ArrayList<Instance> instances = new ArrayList<Instance>();
            for (Token token : (Collection)sentencesTokens.get(sentence)) {
                Instance instance = new Instance();
                for (FeatureExtractor1<Token> extractor : this.featureExtractors) {
                    if (extractor instanceof CleartkExtractor) {
                        instance.addAll((Collection)((CleartkExtractor)extractor).extractWithin(jCas, (Annotation)token, (Annotation)sentence));
                        continue;
                    }
                    instance.addAll((Collection)extractor.extract(jCas, (Annotation)token));
                }
                if (this.isTraining()) {
                    GoldNamedEntity goldNE = (GoldNamedEntity)((Object)JCasUtil.selectCovered((JCas)jCas, GoldNamedEntity.class, (AnnotationFS)token).get(0));
                    instance.setOutcome((Object)goldNE.getNamedEntityType());
                }
                instances.add(instance);
            }
            if (this.isTraining()) {
                this.dataWriter.write(instances);
                continue;
            }
            sentencesInstances.put(index, instances);
            sentenceList.add(sentence);
            if (index > 0 && index % 10000 == 0) {
                this.classify(jCas, sentencesTokens, sentencesInstances, sentenceList, index, it, this.getCrfsuiteOutputfile());
                System.out.println(it * index + " sentences are classified");
                ++it;
                sentenceList.clear();
                sentencesInstances.clear();
                index = 0;
                continue;
            }
            ++index;
        }
        if (!this.isTraining() && index > 0) {
            this.classify(jCas, sentencesTokens, sentencesInstances, sentenceList, index, it, this.getCrfsuiteOutputfile());
        }
    }

    private void classify(JCas jCas, Map<Sentence, Collection<Token>> sentencesTokens, Map<Integer, List<Instance<String>>> sentencesInstances, List<Sentence> sentenceList, int index, int it, File outputFile) throws CleartkProcessingException {
        List namedEntities = this.classify(sentencesInstances, outputFile);
        int i = 0;
        for (Sentence s : sentenceList) {
            for (Token token : sentencesTokens.get(s)) {
                NamedEntity namedEntity = new NamedEntity(jCas, token.getBegin(), token.getEnd());
                namedEntity.setValue((String)namedEntities.get(i));
                namedEntity.addToIndexes();
                ++i;
            }
            ++i;
        }
    }

    private File computeCrfsuiteOutputFile() {
        if (this.outputFile == null) {
            throw new IllegalArgumentException("need a value for param 'PredictionOutputPath' to perform predictions");
        }
        File tmpFile = File.createTempFile(this.outputFile.getName() + ".", ".crfsuite", this.outputFile.getParentFile());
        tmpFile.deleteOnExit();
        return tmpFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public File getCrfsuiteOutputfile() {
        Object value = this.crfsuiteOutputfile.get();
        if (value == null) {
            AtomicReference<Object> atomicReference = this.crfsuiteOutputfile;
            synchronized (atomicReference) {
                value = this.crfsuiteOutputfile.get();
                if (value == null) {
                    File actualValue = this.computeCrfsuiteOutputFile();
                    value = actualValue == null ? this.crfsuiteOutputfile : actualValue;
                    this.crfsuiteOutputfile.set(value);
                }
            }
        }
        return (File)(value == this.crfsuiteOutputfile ? null : value);
    }
}

