package de.tu.darmstadt.lt.ner

import com.google.common.cache.{CacheBuilder, CacheLoader, LoadingCache}
import resource._

import scala.annotation.tailrec
import scala.util.{Failure, Success, Try}

import java.util.concurrent.Semaphore
import java.util.concurrent.locks.Lock

/**
  * Created by Markus Ackermann.
  * No rights reserved.
  */
package object util {

  def loadingCache[K <: AnyRef, V <: AnyRef](loader: K => V): LoadingCache[K, V] =
    CacheBuilder.newBuilder().concurrencyLevel(4).build[K, V](
      new CacheLoader[K, V] {

        override def load(key: K): V = loader(key)
      }
    )
}
