package de.tu.darmstadt.lt.ner.util;

import lombok.AllArgsConstructor;
import lombok.Getter;
import lombok.SneakyThrows;
import lombok.val;

import java.io.IOException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Properties;


public class Configuration {

    @Getter private final Properties properties;

    @SneakyThrows(IOException.class)
    public Configuration(String sourceURL) {

        properties = new Properties();
        val configInput = new URL(sourceURL).openStream();
        try {
            properties.load(configInput);
        } finally {
            configInput.close();
        }
    }

    @SneakyThrows(IOException.class)
    public void writeTo(Path file) {

        val output = Files.newOutputStream(file);
        try {
            properties.store(output, "");
        } finally {
            output.close();
        }
    }

    public boolean usePosition() {

        return properties.getProperty("usePosition", "0").equals("1") ? true : false;
    }

    public boolean useFreeBase() {

        return properties.getProperty("useFreeBase", "0").equals("1") ? true : false;
    }

    public boolean useClarkPosInduction() {

        return properties.getProperty("useClarkPosInduction", "0").equals("1") ? true: false;
    };
}
